/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.queclinkadapter.tracker;

import com.sap.sailing.domain.queclinkadapter.FRIReport;
import com.sap.sailing.domain.queclinkadapter.Message;
import com.sap.sailing.domain.queclinkadapter.MessageParser;
import com.sap.sailing.domain.queclinkadapter.PositionRelatedReport;
import com.sap.sailing.domain.queclinkadapter.impl.AbstractMessageVisitor;
import com.sap.sailing.domain.queclinkadapter.impl.PositionRelatedReportToGPSFixConverter;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.trackfiles.common.BaseGPSFixImporterImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;

public class QueclinkGPSFixImporter
extends BaseGPSFixImporterImpl {
    public boolean importFixes(InputStream inputStream, Charset charset, final GPSFixImporter.Callback callback, final boolean inferSpeedAndBearing, final String sourceName) throws Exception {
        final HashMap deviceIdentifiersForImeis = new HashMap();
        final PositionRelatedReportToGPSFixConverter converter = new PositionRelatedReportToGPSFixConverter();
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        MessageParser parser = MessageParser.create();
        AbstractMessageVisitor<Void> visitor = new AbstractMessageVisitor<Void>(){

            @Override
            public Void visit(FRIReport friReport) {
                TrackFileImportDeviceIdentifier deviceIdentifier = deviceIdentifiersForImeis.computeIfAbsent(friReport.getImei(), imei -> new TrackFileImportDeviceIdentifierImpl(sourceName, imei));
                PositionRelatedReport[] positionRelatedReportArray = friReport.getPositionRelatedReports();
                int n = positionRelatedReportArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionRelatedReport prr = positionRelatedReportArray[n2];
                    if (prr.getPosition() != null) {
                        QueclinkGPSFixImporter.this.addFixAndInfer(callback, inferSpeedAndBearing, converter.createGPSFixFromPositionRelatedReport(prr), deviceIdentifier);
                    }
                    ++n2;
                }
                return null;
            }
        };
        for (Message m : parser.parse(reader)) {
            m.accept(visitor);
        }
        return true;
    }

    public Iterable<String> getSupportedFileExtensions() {
        return Arrays.asList("qec", "", "log");
    }

    public String getType() {
        return "Queclink GPS Fix Importer";
    }
}

