/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.concurrent;

import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -5618926487507116463L;
    private transient NamedReentrantReadWriteLock lock;
    private volatile Map<K, V> wrappedMap;

    public CopyOnWriteHashMap() {
        this("lock for CopyOnWriteHashMap");
    }

    public CopyOnWriteHashMap(String lockName) {
        this.lock = new NamedReentrantReadWriteLock(lockName, true);
        this.wrappedMap = new HashMap();
    }

    public CopyOnWriteHashMap(String lockName, Map<? extends K, ? extends V> initialValues) {
        this.lock = new NamedReentrantReadWriteLock(lockName, true);
        this.wrappedMap = new HashMap<K, V>(initialValues);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.lock.getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String lockName = (String)ois.readObject();
        if (this.lock == null) {
            this.lock = new NamedReentrantReadWriteLock(lockName, true);
        }
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        LockUtil.lockForWrite(this.lock);
        try {
            HashMap<K, V> copy = new HashMap<K, V>(this.wrappedMap);
            V result = copy.put(key, value);
            this.wrappedMap = copy;
            V v = result;
            return v;
        }
        finally {
            LockUtil.unlockAfterWrite(this.lock);
        }
    }

    @Override
    public V remove(Object key) {
        LockUtil.lockForWrite(this.lock);
        try {
            HashMap<K, V> copy = new HashMap<K, V>(this.wrappedMap);
            Object result = copy.remove(key);
            this.wrappedMap = copy;
            Object v = result;
            return v;
        }
        finally {
            LockUtil.unlockAfterWrite(this.lock);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> values) {
        LockUtil.lockForWrite(this.lock);
        try {
            HashMap<? extends K, ? extends V> copy = new HashMap<K, V>(this.wrappedMap);
            copy.putAll(values);
            this.wrappedMap = copy;
        }
        finally {
            LockUtil.unlockAfterWrite(this.lock);
        }
    }

    @Override
    public void clear() {
        LockUtil.lockForWrite(this.lock);
        try {
            this.wrappedMap = new HashMap();
        }
        finally {
            LockUtil.unlockAfterWrite(this.lock);
        }
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.wrappedMap.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.wrappedMap.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.wrappedMap.entrySet());
    }

    public void set(Map<? extends K, ? extends V> values) {
        LockUtil.lockForWrite(this.lock);
        try {
            this.wrappedMap = values == null ? new HashMap() : new HashMap<K, V>(values);
        }
        finally {
            LockUtil.unlockAfterWrite(this.lock);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wrappedMap == null ? 0 : this.wrappedMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyOnWriteHashMap other = (CopyOnWriteHashMap)obj;
        return !(this.wrappedMap == null ? other.wrappedMap != null : !this.wrappedMap.equals(other.wrappedMap));
    }
}

