/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl.doublefix;

import com.sap.sailing.domain.trackimport.DoubleVectorFixImporter;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleFixProcessor;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleVectorFixData;
import java.util.ArrayList;
import java.util.logging.Logger;

public final class DownsamplerTo1HzProcessor
implements DoubleFixProcessor {
    private final Logger LOG = Logger.getLogger(DoubleVectorFixImporter.class.getName());
    private final ArrayList<DoubleVectorFixData> fixesInTheCurrentSecond = new ArrayList();
    private final int nrOfColumsInTrack;
    private final DoubleFixProcessor delegateProcesssor;
    private long currentSecond = 0L;
    private long currentOffsetInMs = 0L;
    private long countSourceTtl = 0L;
    private long countImportedTtl = 0L;

    public DownsamplerTo1HzProcessor(int nrOfColumsInTrack, DoubleFixProcessor consumerOfConsolidatedFixes) {
        this.nrOfColumsInTrack = nrOfColumsInTrack;
        this.delegateProcesssor = consumerOfConsolidatedFixes;
    }

    @Override
    public void accept(DoubleVectorFixData fix) {
        if (fix == null) {
            return;
        }
        fix.correctTimepointBy(this.currentOffsetInMs);
        if (fix.getFixSecond() < this.currentSecond) {
            this.currentOffsetInMs = (this.currentSecond - fix.getFixSecond() + 1L) * 1000L;
            this.LOG.warning("Timepoint before last second, using offset of " + this.currentOffsetInMs + "ms from now on");
        }
        if (this.currentSecond != fix.getFixSecond()) {
            this.computeDownsampledFixForCurrentSecond();
            this.currentSecond = fix.getFixSecond();
        }
        ++this.countSourceTtl;
        this.fixesInTheCurrentSecond.add(fix);
    }

    @Override
    public void finish() {
        this.computeDownsampledFixForCurrentSecond();
        this.delegateProcesssor.finish();
        this.LOG.fine("Imported " + this.countImportedTtl + " fixes from " + this.countSourceTtl);
    }

    private void computeDownsampledFixForCurrentSecond() {
        Double[] computedAverage = new Double[this.nrOfColumsInTrack];
        int[] counts = new int[this.nrOfColumsInTrack];
        int numberOfFixesInSecond = this.fixesInTheCurrentSecond.size();
        if (numberOfFixesInSecond == 0) {
            return;
        }
        for (DoubleVectorFixData d : this.fixesInTheCurrentSecond) {
            Double[] fix = d.getFix();
            int colIdx = 0;
            while (colIdx < this.nrOfColumsInTrack) {
                if (fix[colIdx] != null) {
                    if (computedAverage[colIdx] == null) {
                        computedAverage[colIdx] = fix[colIdx];
                    } else {
                        int n = colIdx;
                        computedAverage[n] = computedAverage[n] + fix[colIdx];
                    }
                    int n = colIdx;
                    counts[n] = counts[n] + 1;
                }
                ++colIdx;
            }
        }
        this.fixesInTheCurrentSecond.clear();
        int colIdx = 0;
        while (colIdx < this.nrOfColumsInTrack) {
            if (computedAverage[colIdx] != null) {
                int n = colIdx;
                computedAverage[n] = computedAverage[n] / (double)counts[colIdx];
            }
            ++colIdx;
        }
        this.delegateProcesssor.accept(new DoubleVectorFixData(this.currentSecond * 1000L + 500L, computedAverage));
        ++this.countImportedTtl;
    }

    public long getCountImportedTtl() {
        return this.countImportedTtl;
    }

    public long getCountSourceTtl() {
        return this.countSourceTtl;
    }
}

