/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model;

import com.sap.sailing.domain.maneuverdetection.ShortTimeAfterLastHitCache;
import com.sap.sailing.windestimation.model.ModelCache;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.ModelFactory;
import com.sap.sailing.windestimation.model.ModelLoader;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelStore;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractModelCache<InstanceType, MC extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, MC>>
implements ModelCache<InstanceType, ModelType> {
    private static final Logger logger = Logger.getLogger(AbstractModelCache.class.getName());
    private final ShortTimeAfterLastHitCache<MC, ModelType> modelCache;
    private final ModelLoader<InstanceType, MC, ModelType> modelLoader;
    private final long preserveLoadedModelsMillis;
    private final ModelFactory<InstanceType, MC, ModelType> modelFactory;
    private final boolean preloadAllModels;

    public AbstractModelCache(ModelStore modelStore, boolean preloadAllModels, long preserveLoadedModelsMillis, ModelFactory<InstanceType, MC, ModelType> modelFactory) {
        this.preloadAllModels = preloadAllModels;
        this.preserveLoadedModelsMillis = preserveLoadedModelsMillis;
        this.modelFactory = modelFactory;
        this.modelCache = new ShortTimeAfterLastHitCache(preserveLoadedModelsMillis, modelContext -> this.loadUncachedModel(modelContext));
        this.modelLoader = new ModelLoader(modelContext -> (TrainableModel)this.modelCache.getCachedValue((Object)modelContext), modelStore, modelFactory);
        if (preloadAllModels) {
            this.preloadAllModels();
        }
    }

    private void preloadAllModels() {
        try {
            Map<MC, ModelType> bestModelsPerModelContext = this.modelLoader.loadBestModelsForAllContexts();
            for (Map.Entry<MC, ModelType> entry : bestModelsPerModelContext.entrySet()) {
                this.modelCache.addToCache((Object)((ModelContext)entry.getKey()), (Object)((TrainableModel)entry.getValue()));
            }
        }
        catch (ModelLoadingException e) {
            logger.log(Level.SEVERE, "Problem loading wind estimation models: " + e.getMessage() + ". Leaving model cache empty. Perhaps the activator will try to import from elsewhere?", e);
        }
    }

    private ModelType loadUncachedModel(MC modelContext) {
        ModelType bestModel = this.modelLoader.loadBestModel(modelContext);
        return bestModel;
    }

    @Override
    public ModelType getBestModel(MC modelContext) {
        return (ModelType)((TrainableModel)this.modelCache.getValue(modelContext));
    }

    @Override
    public ModelType getBestModel(InstanceType instance) {
        MC modelContext = this.getModelContext(instance);
        ModelType bestModel = this.getBestModel((InstanceType)modelContext);
        return bestModel;
    }

    public abstract MC getModelContext(InstanceType var1);

    public long getPreserveLoadedModelsMillis() {
        return this.preserveLoadedModelsMillis;
    }

    @Override
    public void clearCache() {
        this.modelCache.clearCache();
        if (this.preloadAllModels) {
            this.preloadAllModels();
        }
    }

    @Override
    public boolean isReady() {
        ModelType omnipresentModel = this.getBestModel((InstanceType)this.modelFactory.getModelContextWhichModelAreAlwaysPresent());
        return omnipresentModel != null && omnipresentModel.isModelReady();
    }

    @Override
    public ModelDomainType getModelDomainType() {
        return this.modelFactory.getModelDomainType();
    }

    @Override
    public boolean isPreloadAllModels() {
        return this.preloadAllModels;
    }
}

