/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.data;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedImpl;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.List;

public class CompetitorTrackWithEstimationData<T> {
    private final String regattaName;
    private final String raceName;
    private final String competitorName;
    private final BoatClass boatClass;
    private final List<T> elements;
    private final double avgIntervalBetweenFixesInSeconds;
    private final Distance distanceTravelled;
    private final TimePoint trackStartTimePoint;
    private final TimePoint trackEndTimePoint;
    private final int markPassingsCount;
    private final int waypointsCount;

    public CompetitorTrackWithEstimationData(String regattaName, String raceName, String competitorName, BoatClass boatClass, List<T> elements, double avgIntervalBetweenFixesInSeconds, Distance distanceTravelled, TimePoint trackStartTimePoint, TimePoint trackEndTimePoint, int markPassingsCount, int waypointsCount) {
        this.competitorName = competitorName;
        this.boatClass = boatClass;
        this.elements = elements;
        this.avgIntervalBetweenFixesInSeconds = avgIntervalBetweenFixesInSeconds;
        this.distanceTravelled = distanceTravelled;
        this.trackStartTimePoint = trackStartTimePoint;
        this.trackEndTimePoint = trackEndTimePoint;
        this.markPassingsCount = markPassingsCount;
        this.waypointsCount = waypointsCount;
        this.regattaName = regattaName;
        this.raceName = raceName;
    }

    public String getCompetitorName() {
        return this.competitorName;
    }

    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public double getAvgIntervalBetweenFixesInSeconds() {
        return this.avgIntervalBetweenFixesInSeconds;
    }

    public Distance getDistanceTravelled() {
        return this.distanceTravelled;
    }

    public Duration getDuration() {
        return this.trackStartTimePoint == null || this.trackEndTimePoint == null ? Duration.NULL : this.trackStartTimePoint.until(this.trackEndTimePoint);
    }

    public TimePoint getTrackStartTimePoint() {
        return this.trackStartTimePoint;
    }

    public TimePoint getTrackEndTimePoint() {
        return this.trackEndTimePoint;
    }

    public int getMarkPassingsCount() {
        return this.markPassingsCount;
    }

    public int getWaypointsCount() {
        return this.waypointsCount;
    }

    public String getRegattaName() {
        return this.regattaName;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public boolean isClean() {
        if (this.avgIntervalBetweenFixesInSeconds < 8.0) {
            MeterPerSecondSpeedImpl meterPerSecondSpeedImpl = new MeterPerSecondSpeedImpl(this.distanceTravelled.getMeters() / this.trackStartTimePoint.until(this.trackEndTimePoint).asSeconds());
            if (meterPerSecondSpeedImpl.getKnots() > 2.0) {
                return true;
            }
        }
        return false;
    }

    public <S> CompetitorTrackWithEstimationData<S> constructWithElements(List<S> elements) {
        return new CompetitorTrackWithEstimationData<S>(this.getRegattaName(), this.getRaceName(), this.getCompetitorName(), this.getBoatClass(), elements, this.getAvgIntervalBetweenFixesInSeconds(), this.getDistanceTravelled(), this.getTrackStartTimePoint(), this.getTrackEndTimePoint(), this.getMarkPassingsCount(), this.getWaypointsCount());
    }
}

