/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;
import com.sap.sailing.windestimation.aggregator.hmm.SimpleIntersectedWindRangeBasedTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.hmm.WindCourseRange;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphNodeTransitionProbabilitiesCalculator;
import com.sap.sailing.windestimation.aggregator.msthmm.PreviousNodeInfo;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.data.TwdTransition;
import com.sap.sailing.windestimation.model.regressor.twdtransition.GaussianBasedTwdTransitionDistributionCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;

public class DistanceAndDurationAwareWindTransitionProbabilitiesCalculator
extends SimpleIntersectedWindRangeBasedTransitionProbabilitiesCalculator<MstGraphLevel>
implements MstGraphNodeTransitionProbabilitiesCalculator {
    private static final double LA_PLACE_TRANSITION_PROBABILITY = 1.0E-16;
    private final GaussianBasedTwdTransitionDistributionCache gaussianBasedTwdTransitionDistributionCache;

    public DistanceAndDurationAwareWindTransitionProbabilitiesCalculator(GaussianBasedTwdTransitionDistributionCache gaussianBasedTwdTransitionDistributionCache, boolean propagateIntersectedWindRangeOfHeadupAndBearAway) {
        super(propagateIntersectedWindRangeOfHeadupAndBearAway);
        this.gaussianBasedTwdTransitionDistributionCache = gaussianBasedTwdTransitionDistributionCache;
    }

    @Override
    protected double getPenaltyFactorForTransition(TwdTransition twdTransition) {
        double penaltyFactor = this.gaussianBasedTwdTransitionDistributionCache.getProbability(twdTransition);
        return penaltyFactor + 1.0E-16;
    }

    @Override
    public double getCompoundDistance(ManeuverForEstimation fromManeuver, ManeuverForEstimation toManeuver) {
        Duration durationPassed = this.getDuration(fromManeuver, toManeuver);
        Distance distancePassed = this.getDistance(fromManeuver, toManeuver);
        TwdTransition twdTransition = this.constructTwdTransition(durationPassed, distancePassed, 0.0, ManeuverTypeForClassification.TACK, ManeuverTypeForClassification.TACK);
        double compoundDistance = this.gaussianBasedTwdTransitionDistributionCache.getCompoundDistance(twdTransition);
        return compoundDistance;
    }

    @Override
    public double getTransitionProbability(GraphNode<MstGraphLevel> currentNode, GraphNode<MstGraphLevel> previousNode, double combinedDistanceBetweenNodes) {
        IntersectedWindRange intersectedWindRange = previousNode.getValidWindRange().intersect(currentNode.getValidWindRange(), WindCourseRange.CombinationModeOnViolation.INTERSECTION);
        double transitionProbability = this.gaussianBasedTwdTransitionDistributionCache.getGaussianProbability(combinedDistanceBetweenNodes, intersectedWindRange.getViolationRange()) + 1.0E-16;
        return transitionProbability;
    }

    @Override
    public Util.Pair<IntersectedWindRange, Double> mergeWindRangeAndGetTransitionProbability(GraphNode<MstGraphLevel> currentNode, MstGraphLevel currentLevel, PreviousNodeInfo previousNodeInfo) {
        IntersectedWindRange[] intersectedWindRanges = new IntersectedWindRange[currentLevel.getLevelNodes().size()];
        MstGraphLevel previousLevel = previousNodeInfo.getPreviousLevel();
        double stdSum = previousLevel.getDistanceToParent();
        for (GraphNode node : currentLevel.getLevelNodes()) {
            IntersectedWindRange intersectedWindRange = previousNodeInfo.getPreviousNodeIntersectedWindRange().intersect(node.getValidWindRange(), WindCourseRange.CombinationModeOnViolation.INTERSECTION);
            int nodeIndex = node.getIndexInLevel();
            IntersectedWindRange intersectedWindRange2 = intersectedWindRanges[nodeIndex] = intersectedWindRanges[nodeIndex] == null ? intersectedWindRange : intersectedWindRanges[nodeIndex].intersect(intersectedWindRange, WindCourseRange.CombinationModeOnViolation.EXPANSION);
        }
        double transitionProbabilitySum = 0.0;
        double transitionProbabilityUntilCurrentNode = -1.0;
        IntersectedWindRange intersectedWindRangeUntilCurrentNode = null;
        int i = 0;
        while (i < intersectedWindRanges.length) {
            IntersectedWindRange intersectedWindRange = intersectedWindRanges[i];
            double transitionProbability = this.gaussianBasedTwdTransitionDistributionCache.getGaussianProbability(stdSum, intersectedWindRange.getViolationRange());
            transitionProbabilitySum += (transitionProbability += 1.0E-16);
            if (i == currentNode.getIndexInLevel()) {
                transitionProbabilityUntilCurrentNode = transitionProbability;
                intersectedWindRangeUntilCurrentNode = this.propagateIntersectedWindRangeOfHeadupAndBearAway && (currentNode.getManeuverType() == ManeuverTypeForClassification.BEAR_AWAY || currentNode.getManeuverType() == ManeuverTypeForClassification.HEAD_UP) ? intersectedWindRange : currentNode.getValidWindRange().toIntersected();
            }
            ++i;
        }
        if (transitionProbabilityUntilCurrentNode < 0.0) {
            throw new IllegalArgumentException("currentNode not contained in currentLevel");
        }
        double normalizedTransitionProbabilityUntilCurrentNode = transitionProbabilityUntilCurrentNode / transitionProbabilitySum;
        return new Util.Pair(intersectedWindRangeUntilCurrentNode, (Object)normalizedTransitionProbabilityUntilCurrentNode);
    }
}

