/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.server.subscription.chargebee;

import com.chargebee.models.PortalSession;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.ui.client.subscription.chargebee.ChargebeeSubscriptionService;
import com.sap.sse.security.ui.server.subscription.SubscriptionServiceImpl;
import com.sap.sse.security.ui.shared.subscription.SubscriptionDTO;
import com.sap.sse.security.ui.shared.subscription.SubscriptionListDTO;
import com.sap.sse.security.ui.shared.subscription.SubscriptionPlanDTO;
import com.sap.sse.security.ui.shared.subscription.chargebee.ChargebeeSubscriptionDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChargebeeSubscriptionServiceImpl
extends SubscriptionServiceImpl
implements ChargebeeSubscriptionService {
    private static final long serialVersionUID = -4276839013785711262L;
    private static final Logger logger = Logger.getLogger(ChargebeeSubscriptionServiceImpl.class.getName());

    public ArrayList<SubscriptionPlanDTO> getAllSubscriptionPlans() {
        ArrayList<SubscriptionPlanDTO> result = new ArrayList<SubscriptionPlanDTO>();
        Collection plans = this.getSecurityService().getAllSubscriptionPlans().values();
        plans.forEach(plan -> result.add(this.convertToDto(plan)));
        return result;
    }

    public SubscriptionListDTO getSubscriptions(Boolean activeOnly) {
        SubscriptionListDTO subscriptionDto = null;
        try {
            User user = this.getCurrentUser();
            Iterable subscriptions = user.getSubscriptions();
            if (subscriptions != null) {
                ArrayList<ChargebeeSubscriptionDTO> itemList = new ArrayList<ChargebeeSubscriptionDTO>();
                for (Subscription subscription : subscriptions) {
                    if (!subscription.hasSubscriptionId() || activeOnly.booleanValue() && this.isSubscriptionCancelled(subscription)) continue;
                    itemList.add(new ChargebeeSubscriptionDTO(subscription.getPlanId(), subscription.getSubscriptionId(), subscription.getSubscriptionStatus(), subscription.getPaymentStatus(), subscription.getTransactionType(), subscription.getReoccuringPaymentValue(), subscription.getCurrencyCode(), subscription.getSubscriptionCreatedAt(), subscription.getTrialEnd(), subscription.getCurrentTermEnd(), subscription.getCancelledAt(), subscription.getNextBillingAt()));
                }
                if (!itemList.isEmpty()) {
                    subscriptionDto = new SubscriptionListDTO(itemList.toArray(new SubscriptionDTO[0]), null);
                }
            }
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            subscriptionDto = new SubscriptionListDTO(null, e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting subscription ", e);
            subscriptionDto = new SubscriptionListDTO(null, e.getMessage());
        }
        return subscriptionDto;
    }

    protected String getProviderName() {
        return "chargebee";
    }

    protected boolean isSubscriptionCancelled(Subscription subscription) {
        return subscription != null && subscription.getSubscriptionStatus().equalsIgnoreCase("cancelled");
    }

    public SubscriptionPlanDTO getSubscriptionPlanDTOById(String planId) {
        SubscriptionPlan subscriptionPlanById = this.getSecurityService().getSubscriptionPlanById(planId);
        return subscriptionPlanById == null ? null : this.convertToDto(subscriptionPlanById);
    }

    public String getSelfServicePortalSession() {
        try {
            User currentUser = this.getCurrentUser();
            CompletableFuture result = new CompletableFuture();
            this.getApiService().getUserSelfServicePortalSession(currentUser.getId().toString(), session -> {
                boolean bl = result.complete(session);
            });
            PortalSession portalSession = (PortalSession)result.get();
            if (portalSession != null) {
                return portalSession.accessUrl();
            }
            return null;
        }
        catch (UserManagementException e) {
            logger.log(Level.FINE, "No user is logged in.");
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting session", e);
            return null;
        }
    }
}

