/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.oauth.client.util;

import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import com.sap.sse.security.ui.oauth.client.CredentialDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientUtils {
    private static final String AUTH_PROVIDER_COOKIE = "sapsailing_provider";
    private static final String AUTH_PROVIDER_NAME_COOKIE = "sapsailing_provider_name";
    private static final String USERNAME_COOKIE = "sapsailing_user";
    private static final String REDIRECT_URL_COOKIE = "sapsailing_redirect_url";
    public static final int DIALOG_X_POSITION = 20;
    public static final int DIALOG_Y_POSITION = 110;
    private static final String APP_CALLBACK_URL = "http://local.sapsailing.com:8888/security/ui/redirect?redirectTo=oauthlogin";
    private static final String FACEBOOK_PROTECTED_RESOURCE_URL = "https://graph.facebook.com/me";
    private static final String GOOGLE_PROTECTED_RESOURSE_URL = "https://www.googleapis.com/oauth2/v1/userinfo";
    private static final String TWITTER_PROTECTED_RESOURCE_URL = "https://api.twitter.com/1/account/verify_credentials.json";
    private static final String YAHOO_PROTECTED_RESOURCE_URL = "http://social.yahooapis.com/v1/user/%s/profile?format=json";
    private static final String LINKEDIN_PROTECTED_RESOURCE_URL = "http://api.linkedin.com/v1/people/~?format=json";
    private static final String INSTAGRAM_PROTECTED_RESOURCE_URL = "https://api.instagram.com/v1/users/%s/?access_token=%s";
    private static final String IMGUR_PROTECTED_RESOURCE_URL = "http://api.imgur.com/2/account.json";
    private static final String GITHUB_PROTECTED_RESOURCE_URL = "https://api.github.com/user?access_token=%s";
    private static final String LIVE_PROTECTED_RESOURCE_URL = "https://apis.live.net/v5.0/me";
    private static final String FLICKR_PROTECTED_RESOURCE_URL = "http://api.flickr.com/services/rest?format=json&nojsoncallback=1&method=flickr.test.login";
    private static final String VIMEO_PROTECTED_RESOURCE_URL = "http://vimeo.com/api/rest/v2?format=json&method=vimeo.people.getInfo";
    private static final String TUMBLR_PROTECTED_RESOURCE_URL = "https://api.tumblr.com/v2/user/info";
    private static final String FOURSQUARE_PROTECTED_RESOURCE_URL = "https://api.foursquare.com/v2/users/self?oauth_token=%s";
    public static final String SESSION_EXPIRED_MESSAGE = "Session has expired";
    private static String[] authProviders = new String[]{"Facebook", "Google", "Twitter", "Yahoo!", "Flickr", "ImaGur", "LinkedIn", "Windows Live", "Instagram", "github", "Vimeo", "Evernote", "tumblr.", "foursquare"};
    public static final int UNKNOWN = -1;
    public static final int DEFAULT = 0;
    public static final int FACEBOOK = 1;
    public static final int GOOGLE = 2;
    public static final int TWITTER = 3;
    public static final int YAHOO = 4;
    public static final int FLICKR = 5;
    public static final int IMGUR = 6;
    public static final int LINKEDIN = 7;
    public static final int WINDOWS_LIVE = 8;
    public static final int INSTAGRAM = 9;
    public static final int GITHUB = 10;
    public static final int VIMEO = 11;
    public static final int EVERNOTE = 12;
    public static final int TUMBLR = 13;
    public static final int FOURSQUARE = 14;

    public static String[] getAuthProviders() {
        return authProviders;
    }

    public static int getAuthProvider(String authProviderName) {
        int authProvider = 0;
        if ((authProviderName = authProviderName.toLowerCase()).equals("facebook")) {
            return 1;
        }
        if (authProviderName.equals("google")) {
            return 2;
        }
        if (authProviderName.equals("twitter")) {
            return 3;
        }
        if (authProviderName.equals("yahoo!")) {
            return 4;
        }
        if (authProviderName.equals("yahoo")) {
            return 4;
        }
        if (authProviderName.equals("flickr")) {
            return 5;
        }
        if (authProviderName.equals("imgur")) {
            return 6;
        }
        if (authProviderName.equals("linkedin")) {
            return 7;
        }
        if (authProviderName.equals("windows live")) {
            return 8;
        }
        if (authProviderName.equals("instagram")) {
            return 9;
        }
        if (authProviderName.equals("github")) {
            return 10;
        }
        if (authProviderName.equals("vimeo")) {
            return 11;
        }
        if (authProviderName.equals("evernote")) {
            return 12;
        }
        if (authProviderName.equals("tumblr.")) {
            return 13;
        }
        if (authProviderName.equals("foursquare")) {
            return 14;
        }
        return authProvider;
    }

    public static String getAuthProviderName(int authProvider) {
        if (authProvider == 1) {
            return "Facebook";
        }
        if (authProvider == 2) {
            return "Google";
        }
        if (authProvider == 3) {
            return "Twitter";
        }
        if (authProvider == 4) {
            return "Yahoo!";
        }
        if (authProvider == 5) {
            return "Flicker";
        }
        if (authProvider == 6) {
            return "ImGur";
        }
        if (authProvider == 7) {
            return "LinkedIn";
        }
        if (authProvider == 8) {
            return "Windows Live";
        }
        if (authProvider == 9) {
            return "Instagram";
        }
        if (authProvider == 10) {
            return "github";
        }
        if (authProvider == 11) {
            return "vimeo";
        }
        if (authProvider == 12) {
            return "Evernote";
        }
        if (authProvider == 13) {
            return "tumblr.";
        }
        if (authProvider == 14) {
            return "foursquare";
        }
        return "Default";
    }

    public static String getCallbackUrl() {
        return "http://local.sapsailing.com:8888/security/ui/redirect?redirectTo=oauthlogin";
    }

    public static String getProctedResourceUrl(int authProvider) {
        switch (authProvider) {
            case 1: {
                return "https://graph.facebook.com/me";
            }
            case 2: {
                return "https://www.googleapis.com/oauth2/v1/userinfo";
            }
            case 3: {
                return "https://api.twitter.com/1/account/verify_credentials.json";
            }
            case 4: {
                return "http://social.yahooapis.com/v1/user/%s/profile?format=json";
            }
            case 7: {
                return "http://api.linkedin.com/v1/people/~?format=json";
            }
            case 9: {
                return "https://api.instagram.com/v1/users/%s/?access_token=%s";
            }
            case 6: {
                return "http://api.imgur.com/2/account.json";
            }
            case 10: {
                return "https://api.github.com/user?access_token=%s";
            }
            case 5: {
                return "http://api.flickr.com/services/rest?format=json&nojsoncallback=1&method=flickr.test.login";
            }
            case 11: {
                return "http://vimeo.com/api/rest/v2?format=json&method=vimeo.people.getInfo";
            }
            case 8: {
                return "https://apis.live.net/v5.0/me";
            }
            case 13: {
                return "https://api.tumblr.com/v2/user/info";
            }
            case 14: {
                return "https://api.foursquare.com/v2/users/self?oauth_token=%s";
            }
        }
        return null;
    }

    public static void clearCookies() {
        Cookies.removeCookie((String)"sapsailing_provider");
        Cookies.removeCookie((String)"sapsailing_provider_name");
        Cookies.removeCookie((String)"sapsailing_user");
        Cookies.removeCookie((String)"sapsailing_redirect_url");
    }

    public static String getAuthProviderFromCookie() {
        return Cookies.getCookie((String)"sapsailing_provider");
    }

    public static int getAuthProviderFromCookieAsInt() {
        String authProviderStr = ClientUtils.getAuthProviderFromCookie();
        int authProvider = -1;
        if (authProviderStr != null) {
            try {
                authProvider = Integer.parseInt(authProviderStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return authProvider;
    }

    public static String getAuthProviderNameFromCookie() {
        return Cookies.getCookie((String)"sapsailing_provider_name");
    }

    public static String getUsernameFromCookie() {
        return Cookies.getCookie((String)"sapsailing_user");
    }

    public static boolean alreadyLoggedIn() {
        return false;
    }

    public static void saveAuthProvider(int authProvider) {
        Cookies.setCookie((String)"sapsailing_provider", (String)Integer.toString(authProvider));
        String authProviderName = ClientUtils.getAuthProviderName((int)authProvider);
        ClientUtils.saveAuthProviderName((String)authProviderName);
    }

    public static void saveAuthProviderName(String authProviderName) {
        Cookies.setCookie((String)"sapsailing_provider_name", (String)authProviderName);
    }

    public static void saveUsername(String username) {
        Cookies.setCookie((String)"sapsailing_user", (String)username);
    }

    public static void saveRediretUrl(String url) {
        Cookies.setCookie((String)"sapsailing_redirect_url", (String)url);
    }

    public static String getRedirectUrlFromCookie() {
        return Cookies.getCookie((String)"sapsailing_redirect_url");
    }

    public static void redirect(String url) {
        Window.Location.assign((String)UriUtils.fromString((String)url).asString());
    }

    public static boolean redirected() {
        String authProvider = ClientUtils.getAuthProviderFromCookie();
        if (authProvider == null) {
            return false;
        }
        if (Window.Location.getParameter((String)"code") != null) {
            return true;
        }
        if (Window.Location.getParameter((String)"oauth_token") != null) {
            return true;
        }
        if (Window.Location.getParameter((String)"oauth_verifier") != null) {
            return true;
        }
        String error = Window.Location.getParameter((String)"error");
        if (error != null) {
            String errorMessage = Window.Location.getParameter((String)"error_description");
            Notification.notify((String)(String.valueOf(error) + ":" + errorMessage), (Notification.NotificationType)Notification.NotificationType.ERROR);
            ClientUtils.reload();
            return false;
        }
        return false;
    }

    public static void reload() {
        String appUrl = ClientUtils.getRedirectUrlFromCookie();
        ClientUtils.clearCookies();
        if (appUrl != null) {
            ClientUtils.redirect((String)appUrl);
        }
    }

    public static CredentialDTO getCredential() throws Exception {
        String authProvider = ClientUtils.getAuthProviderFromCookie();
        if (authProvider == null) {
            return null;
        }
        int ap = 0;
        try {
            ap = Integer.parseInt(authProvider);
        }
        catch (Exception e) {
            throw new Exception("Could not convert authProvider " + authProvider + " to Integer");
        }
        switch (ap) {
            case 0: {
                CredentialDTO credential = new CredentialDTO();
                credential.setAuthProvider(ap);
                return credential;
            }
            case 1: 
            case 9: 
            case 10: {
                CredentialDTO credential = new CredentialDTO();
                credential.setAuthProvider(ap);
                credential.setState(Window.Location.getParameter((String)"state"));
                credential.setVerifier(Window.Location.getParameter((String)"code"));
                return credential;
            }
            case 2: {
                CredentialDTO credential = new CredentialDTO();
                credential.setAuthProvider(ap);
                credential.setVerifier(Window.Location.getParameter((String)"oauth_verifier"));
                return credential;
            }
            case 8: 
            case 14: {
                CredentialDTO credential = new CredentialDTO();
                credential.setAuthProvider(ap);
                credential.setVerifier(Window.Location.getParameter((String)"code"));
                return credential;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                CredentialDTO credential = new CredentialDTO();
                credential.setAuthProvider(ap);
                credential.setVerifier(Window.Location.getParameter((String)"oauth_verifier"));
                return credential;
            }
        }
        throw new Exception("ClientUtils.getCredential: Auth Provider " + authProvider + " Not implemented yet");
    }

    public static void handleException(Throwable caught) {
        if (caught.getMessage().equals("Session has expired")) {
            ClientUtils.showSessionExpires();
        } else {
            ClientUtils.showGenericException((Throwable)caught);
        }
    }

    public static void showSessionExpires() {
        Notification.notify((String)"Your session seems to have expired! You will be logged out.", (Notification.NotificationType)Notification.NotificationType.ERROR);
        ClientUtils.reload();
    }

    public static void showGenericException(Throwable caught) {
        String message = "Exception: " + caught;
        caught.printStackTrace();
        message = String.valueOf(message) + "\n";
        message = String.valueOf(message) + "Please Logout/reload the application";
        Notification.notify((String)message, (Notification.NotificationType)Notification.NotificationType.ERROR);
    }

    public static void logout(UserManagementServiceAsync userManagementService) {
        userManagementService.logout((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static int nthOccurrence(String str, char c, int n) {
        int pos = str.indexOf(c, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }
}

