/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.MaximumTurnTimes;
import com.sap.sailing.simulator.impl.PathGenerator1Turner;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.PolarDiagramBase;
import com.sap.sailing.simulator.impl.SimulationParametersImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindField;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.logging.Logger;

public class PathGeneratorOpportunistEuclidian
extends PathGeneratorBase {
    private static Logger logger = Logger.getLogger("com.sap.sailing");
    SimulationParameters simulationParameters;
    int turns;
    int maxLeft;
    int maxRight;
    MaximumTurnTimes maxTurnTimes;
    boolean startLeft;
    boolean upwindLeg = false;

    public PathGeneratorOpportunistEuclidian(SimulationParameters params) {
        PolarDiagramBase polarDiagramClone = new PolarDiagramBase((PolarDiagramBase)params.getBoatPolarDiagram());
        this.simulationParameters = new SimulationParametersImpl(params.getCourse(), polarDiagramClone, params.getWindField(), params.getSimuStep(), params.getMode(), params.showOmniscient(), params.showOpportunist(), params.getLegType());
    }

    public void setEvaluationParameters(int maxLeft, int maxRight, boolean startLeft) {
        this.maxLeft = maxLeft;
        this.maxRight = maxRight;
        this.startLeft = startLeft;
    }

    public void setEvaluationParameters(MaximumTurnTimes maxTurnTimes, boolean startLeft) {
        this.maxTurnTimes = maxTurnTimes;
        this.startLeft = startLeft;
    }

    public int getTurns() {
        return this.turns;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator wf = this.simulationParameters.getWindField();
        PolarDiagram pd = this.simulationParameters.getBoatPolarDiagram();
        Position start = this.simulationParameters.getCourse().get(0);
        Position end = this.simulationParameters.getCourse().get(1);
        TimePoint startTime = wf.getStartTime();
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        Position currentPosition = start;
        TimePoint currentTime = startTime;
        double currentHeight = start.getDistance(end).getMeters();
        int stepsLeft = 0;
        int stepsRight = 0;
        boolean allLeft = true;
        boolean allRight = true;
        int prevDirection = -1;
        long turnloss = pd.getTurnLoss();
        long windpred = 1000L;
        double fracFinishPhase = 0.05;
        Wind wndStart = wf.getWind(new TimedPositionWithSpeedImpl(startTime, start, null));
        logger.finest("wndStart speed:" + wndStart.getKnots() + " angle:" + wndStart.getBearing().getDegrees());
        pd.setWind((SpeedWithBearing)wndStart);
        Bearing bearStart = currentPosition.getBearingGreatCircle(end);
        path.add(new TimedPositionWithSpeedImpl(startTime, start, (SpeedWithBearing)wndStart));
        long timeStep = wf.getTimeStep().asMillis() / 2L;
        logger.fine("Time step :" + timeStep);
        String legType = "none";
        if (this.simulationParameters.getLegType() == null) {
            Bearing bearRCWind = wndStart.getBearing().getDifferenceTo(bearStart);
            legType = "downwind";
            this.upwindLeg = false;
            if (Math.abs(bearRCWind.getDegrees()) > 90.0 && Math.abs(bearRCWind.getDegrees()) < 270.0) {
                legType = "upwind";
                this.upwindLeg = true;
            }
        } else if (this.simulationParameters.getLegType() == LegType.UPWIND) {
            legType = "upwind";
            this.upwindLeg = true;
        } else {
            legType = "downwind";
            this.upwindLeg = false;
        }
        int timeStepScale = 1;
        if (!this.upwindLeg) {
            timeStepScale = 2;
            timeStep /= (long)timeStepScale;
            turnloss /= (long)timeStepScale;
        }
        if (this.maxTurnTimes != null && (this.maxTurnTimes.left > 0L || this.maxTurnTimes.right > 0L)) {
            this.maxLeft = (int)Math.floor((double)this.maxTurnTimes.left / (double)timeStep);
            this.maxRight = (int)Math.floor((double)this.maxTurnTimes.right / (double)timeStep);
        }
        logger.fine("Leg Direction: " + legType);
        this.turns = 0;
        SpeedWithBearing slft = null;
        SpeedWithBearing srght = null;
        while (currentHeight > 0.0 && currentPosition.getDistance(end).compareTo((Object)start.getDistance(end).scale(fracFinishPhase)) > 0 && path.size() < 500 && !this.isTimedOut()) {
            MillisecondsTimePoint rightTime;
            MillisecondsTimePoint leftTime;
            Bearing wRght;
            Bearing wLft;
            long nextTimeVal = currentTime.asMillis() + timeStep;
            MillisecondsTimePoint nextTime = new MillisecondsTimePoint(nextTimeVal);
            Wind cWind = wf.getWind(new TimedPositionWithSpeedImpl(currentTime, currentPosition, null));
            logger.finest("cWind speed:" + cWind.getKnots() + " angle:" + cWind.getBearing().getDegrees());
            pd.setWind((SpeedWithBearing)cWind);
            if (this.upwindLeg) {
                wLft = pd.optimalDirectionsUpwind()[0];
                wRght = pd.optimalDirectionsUpwind()[1];
            } else {
                wLft = pd.optimalDirectionsDownwind()[0];
                wRght = pd.optimalDirectionsDownwind()[1];
            }
            SpeedWithBearing sWLft = pd.getSpeedAtBearing(wLft);
            SpeedWithBearing sWRght = pd.getSpeedAtBearing(wRght);
            logger.finest("left boat speed:" + sWLft.getKnots() + " angle:" + sWLft.getBearing().getDegrees() + "  right boat speed:" + sWRght.getKnots() + " angle:" + sWRght.getBearing().getDegrees());
            MillisecondsTimePoint wTime = new MillisecondsTimePoint(currentTime.asMillis() + windpred);
            Position pWLft = sWLft.travelTo(currentPosition, currentTime, (TimePoint)wTime);
            Position pWRght = sWRght.travelTo(currentPosition, currentTime, (TimePoint)wTime);
            logger.finest("current Pos:" + currentPosition.getLatDeg() + "," + currentPosition.getLngDeg());
            logger.finest("left    Pos:" + pWLft.getLatDeg() + "," + pWLft.getLngDeg());
            logger.finest("right   Pos:" + pWRght.getLatDeg() + "," + pWRght.getLngDeg());
            Wind lWind = wf.getWind(new TimedPositionWithSpeedImpl(currentTime, pWLft, null));
            logger.finest("lWind speed:" + lWind.getKnots() + " angle:" + lWind.getBearing().getDegrees());
            pd.setWind((SpeedWithBearing)lWind);
            Bearing lft = this.upwindLeg ? pd.optimalDirectionsUpwind()[0] : pd.optimalDirectionsDownwind()[0];
            slft = pd.getSpeedAtBearing(lft);
            Wind rWind = wf.getWind(new TimedPositionWithSpeedImpl(currentTime, pWRght, null));
            logger.finest("rWind speed:" + rWind.getKnots() + " angle:" + rWind.getBearing().getDegrees());
            pd.setWind((SpeedWithBearing)rWind);
            Bearing rght = this.upwindLeg ? pd.optimalDirectionsUpwind()[1] : pd.optimalDirectionsDownwind()[1];
            srght = pd.getSpeedAtBearing(rght);
            logger.finest("left boat speed:" + slft.getKnots() + " angle:" + slft.getBearing().getDegrees() + "  right boat speed:" + srght.getKnots() + " angle:" + srght.getBearing().getDegrees());
            if (prevDirection == 1) {
                leftTime = new MillisecondsTimePoint(nextTimeVal);
                rightTime = new MillisecondsTimePoint(nextTimeVal - turnloss);
            } else if (prevDirection == 2) {
                leftTime = new MillisecondsTimePoint(nextTimeVal - turnloss);
                rightTime = new MillisecondsTimePoint(nextTimeVal);
            } else {
                leftTime = new MillisecondsTimePoint(nextTimeVal);
                rightTime = new MillisecondsTimePoint(nextTimeVal);
            }
            Position plft = slft.travelTo(currentPosition, currentTime, (TimePoint)leftTime);
            Position prght = srght.travelTo(currentPosition, currentTime, (TimePoint)rightTime);
            Distance dlft = plft.getDistance(end);
            Distance drght = prght.getDistance(end);
            double lDistCM = (double)Math.round(dlft.getMeters() * 1000.0) / 1000.0;
            double rDistCM = (double)Math.round(drght.getMeters() * 1000.0) / 1000.0;
            if (prevDirection == -1) {
                if (this.startLeft) {
                    allRight = false;
                    path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, plft, (SpeedWithBearing)lWind));
                    currentPosition = plft;
                    if (prevDirection == 2) {
                        allLeft = false;
                        ++this.turns;
                    } else {
                        ++stepsLeft;
                    }
                    prevDirection = 1;
                } else {
                    allLeft = false;
                    path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, prght, (SpeedWithBearing)rWind));
                    currentPosition = prght;
                    if (prevDirection == 1) {
                        allRight = false;
                        ++this.turns;
                    } else {
                        ++stepsRight;
                    }
                    prevDirection = 2;
                }
            } else if (lDistCM <= rDistCM && (!allLeft || stepsLeft < this.maxLeft) || allRight && stepsRight >= this.maxRight) {
                path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, plft, (SpeedWithBearing)lWind));
                currentPosition = plft;
                if (prevDirection == 2) {
                    allLeft = false;
                    ++this.turns;
                } else {
                    ++stepsLeft;
                }
                prevDirection = 1;
            } else {
                path.add(new TimedPositionWithSpeedImpl((TimePoint)nextTime, prght, (SpeedWithBearing)rWind));
                currentPosition = prght;
                if (prevDirection == 1) {
                    allRight = false;
                    ++this.turns;
                } else {
                    ++stepsRight;
                }
                prevDirection = 2;
            }
            currentTime = nextTime;
            Position posHeight = currentPosition.projectToLineThrough(start, bearStart);
            currentHeight = start.getDistance(end).getMeters() - posHeight.getDistance(start).getMeters();
        }
        if (!this.isTimedOut()) {
            MillisecondsTimePoint rightGoingTime;
            TimePoint leftGoingTime;
            PathGenerator1Turner gen1Turner = new PathGenerator1Turner(this.simulationParameters);
            if (prevDirection == 1) {
                leftGoingTime = currentTime;
                rightGoingTime = new MillisecondsTimePoint(currentTime.asMillis() + turnloss);
            } else {
                leftGoingTime = new MillisecondsTimePoint(currentTime.asMillis() + turnloss);
                rightGoingTime = currentTime;
            }
            gen1Turner.setEvaluationParameters(true, currentPosition, end, leftGoingTime, timeStep / 15L, 100, 0.1, this.upwindLeg);
            Path leftPath = gen1Turner.getPath();
            gen1Turner.setEvaluationParameters(false, currentPosition, end, (TimePoint)rightGoingTime, timeStep / 15L, 100, 0.1, this.upwindLeg);
            Path rightPath = gen1Turner.getPath();
            if (leftPath.getPathPoints() != null && rightPath.getPathPoints() != null) {
                if (leftPath.getPathPoints().get(leftPath.getPathPoints().size() - 1).getTimePoint().asMillis() <= rightPath.getPathPoints().get(rightPath.getPathPoints().size() - 1).getTimePoint().asMillis()) {
                    path.addAll(leftPath.getPathPoints());
                } else {
                    path.addAll(rightPath.getPathPoints());
                }
            } else if (leftPath.getPathPoints() != null) {
                path.addAll(leftPath.getPathPoints());
            } else if (rightPath.getPathPoints() != null) {
                path.addAll(rightPath.getPathPoints());
            }
        }
        return new PathImpl(path, (WindField)wf, this.getTurns(), this.algorithmTimedOut);
    }
}

