/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.CombinedWindAsNavigableSet;
import com.sap.sailing.domain.tracking.impl.VirtualWindTrackImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class CombinedWindTrackImpl
extends VirtualWindTrackImpl {
    private static final long serialVersionUID = -5019721956924343447L;
    private CombinedWindAsNavigableSet virtualInternalRawFixes;

    public CombinedWindTrackImpl(TrackedRace trackedRace, double baseConfidence) {
        super(trackedRace, -1L, baseConfidence, WindSourceType.COMBINED.useSpeed());
        this.virtualInternalRawFixes = this.createVirtualInternalRawFixes(trackedRace);
    }

    protected CombinedWindAsNavigableSet createVirtualInternalRawFixes(TrackedRace trackedRace) {
        return new CombinedWindAsNavigableSet(this, trackedRace, 1000L);
    }

    protected CombinedWindAsNavigableSet getInternalRawFixes() {
        return this.virtualInternalRawFixes;
    }

    protected Position getDefaultPosition(TimePoint at) {
        return this.getTrackedRace().getCenterOfCourse(at);
    }

    @Override
    public long getMillisecondsOverWhichToAverageWind() {
        return 2L * this.getInternalRawFixes().getResolutionInMilliseconds() + 2L;
    }

    @Override
    public Wind getAveragedWind(Position p, TimePoint at) {
        return this.getTrackedRace().getWind(p == null ? this.getDefaultPosition(at) : p, at);
    }

    @Override
    public WindWithConfidence<Util.Pair<Position, TimePoint>> getAveragedWindWithConfidence(Position p, TimePoint at) {
        return this.getTrackedRace().getWindWithConfidence(p == null ? this.getDefaultPosition(at) : p, at);
    }
}

