/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTrackedRegattaAndRaceObserver
implements TrackedRegattaListener {
    private static final Logger log = Logger.getLogger(AbstractTrackedRegattaAndRaceObserver.class.getName());
    private final Map<Serializable, RegattaListener> registeredRegattaListeners = new ConcurrentHashMap<Serializable, RegattaListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void regattaAdded(TrackedRegatta trackedRegatta) {
        Serializable regattaId = trackedRegatta.getRegatta().getId();
        Map<Serializable, RegattaListener> map = this.registeredRegattaListeners;
        synchronized (map) {
            this.stopIfNotNull(this.registeredRegattaListeners.remove(regattaId));
            RegattaListener tracker = new RegattaListener((DynamicTrackedRegatta)trackedRegatta);
            this.registeredRegattaListeners.put(regattaId, tracker);
        }
        log.fine("Added sensor data tracker to tracked regatta: " + trackedRegatta.getRegatta().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void regattaRemoved(TrackedRegatta trackedRegatta) {
        Serializable regattaId = trackedRegatta.getRegatta().getId();
        Map<Serializable, RegattaListener> map = this.registeredRegattaListeners;
        synchronized (map) {
            try {
                this.stopIfNotNull(this.registeredRegattaListeners.get(regattaId));
            }
            finally {
                this.registeredRegattaListeners.remove(regattaId);
            }
        }
    }

    private void stopIfNotNull(RegattaListener tracker) {
        if (tracker != null) {
            try {
                tracker.stop();
            }
            catch (Exception exc) {
                log.log(Level.SEVERE, "Stopping of tracker failed: " + tracker, exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeAll() {
        Map<Serializable, RegattaListener> map = this.registeredRegattaListeners;
        synchronized (map) {
            this.registeredRegattaListeners.values().forEach(this::stopIfNotNull);
        }
    }

    protected abstract void onRaceAdded(RegattaAndRaceIdentifier var1, DynamicTrackedRegatta var2, DynamicTrackedRace var3);

    protected abstract void onRaceRemoved(DynamicTrackedRace var1);

    private class RegattaListener {
        private final Map<RegattaAndRaceIdentifier, DynamicTrackedRace> knownTrackedRaces = new ConcurrentHashMap<RegattaAndRaceIdentifier, DynamicTrackedRace>();
        private final DynamicTrackedRegatta trackedRegatta;
        private final RaceListener raceListener;

        public RegattaListener(DynamicTrackedRegatta trackedRegatta) {
            this.trackedRegatta = trackedRegatta;
            this.raceListener = new RaceListener(){

                @Override
                public void raceRemoved(TrackedRace trackedRace) {
                    RegattaListener.this.raceRemoved(trackedRace);
                }

                @Override
                public void raceAdded(TrackedRace trackedRace) {
                    RegattaListener.this.raceAdded(trackedRace);
                }
            };
            trackedRegatta.addRaceListener(this.raceListener, Optional.empty(), false);
        }

        public synchronized void raceRemoved(TrackedRace trackedRace) {
            this.remove(trackedRace.getRaceIdentifier());
        }

        public synchronized void raceAdded(TrackedRace trackedRace) {
            if (trackedRace instanceof DynamicTrackedRace) {
                DynamicTrackedRace dynamicTrackedRace = (DynamicTrackedRace)trackedRace;
                RegattaAndRaceIdentifier raceIdentifier = dynamicTrackedRace.getRaceIdentifier();
                if (this.knownTrackedRaces.containsKey(raceIdentifier)) {
                    this.remove(raceIdentifier);
                }
                this.knownTrackedRaces.put(raceIdentifier, dynamicTrackedRace);
                AbstractTrackedRegattaAndRaceObserver.this.onRaceAdded(raceIdentifier, this.trackedRegatta, dynamicTrackedRace);
            }
        }

        private void remove(RegattaAndRaceIdentifier raceIdentifier) {
            DynamicTrackedRace removedTrackedRace = this.knownTrackedRaces.remove(raceIdentifier);
            AbstractTrackedRegattaAndRaceObserver.this.onRaceRemoved(removedTrackedRace);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.trackedRegatta.removeRaceListener(this.raceListener).get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.log(Level.SEVERE, "Error while waiting for the raceListener to be removed", e);
            }
            RegattaListener regattaListener = this;
            synchronized (regattaListener) {
                this.knownTrackedRaces.keySet().forEach(this::remove);
                this.knownTrackedRaces.clear();
            }
        }

        public String toString() {
            return "TrackedRegattaAndRaceObserver.RegattaListener [regattaId=" + this.trackedRegatta.getRegatta().getId() + "]";
        }
    }
}

