/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverhash.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.impl.MarkPassingRaceFingerprintImpl;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sse.common.Util;
import java.util.Set;
import org.json.simple.JSONObject;

public class ManeuverRaceFingerprintImpl
extends MarkPassingRaceFingerprintImpl
implements ManeuverRaceFingerprint {
    private final int windHash;
    private final int detectorVersion;

    public ManeuverRaceFingerprintImpl(TrackedRace trackedRace) {
        super(trackedRace);
        this.detectorVersion = 1;
        this.windHash = this.calculateWindHash(trackedRace);
    }

    public ManeuverRaceFingerprintImpl(JSONObject json) {
        super(json);
        this.detectorVersion = ((Number)json.get((Object)JSON_FIELDS.DETECTOR_VERSION.name())).intValue();
        this.windHash = ((Number)json.get((Object)JSON_FIELDS.WIND_HASH.name())).intValue();
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = super.toJson();
        result.put((Object)JSON_FIELDS.DETECTOR_VERSION.name(), (Object)this.detectorVersion);
        result.put((Object)JSON_FIELDS.WIND_HASH.name(), (Object)this.windHash);
        return result;
    }

    @Override
    public boolean matches(TrackedRace trackedRace) {
        boolean result = super.matches(trackedRace);
        if (result) {
            if (!Util.equalsWithNull((Object)this.detectorVersion, (Object)1)) {
                result = false;
            } else if (this.windHash != this.calculateWindHash(trackedRace)) {
                result = false;
            }
        }
        return result;
    }

    private int calculateWindHash(TrackedRace trackedRace) {
        Set<WindSource> windSoures = trackedRace.getWindSources();
        int res = 0;
        Set<WindSource> windSouresToExclude = trackedRace.getWindSourcesToExclude();
        for (WindSource w : windSoures) {
            if (!w.getType().isObserved() || windSouresToExclude.contains(w)) continue;
            WindTrack windTrack = trackedRace.getOrCreateWindTrack(w);
            windTrack.lockForRead();
            try {
                int k = w.getId() == null ? 0 : w.getId().hashCode();
                int v = 0;
                for (Wind wf : trackedRace.getOrCreateWindTrack(w).getFixes()) {
                    v += (int)(wf.getPosition().getLatDeg() + wf.getPosition().getLngDeg() + wf.getKilometersPerHour());
                }
                res ^= k;
                res ^= v;
            }
            finally {
                windTrack.unlockAfterRead();
            }
        }
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.detectorVersion;
        result = 31 * result + this.windHash;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ManeuverRaceFingerprintImpl other = (ManeuverRaceFingerprintImpl)obj;
        if (this.detectorVersion != other.detectorVersion) {
            return false;
        }
        return this.windHash == other.windHash;
    }

    private static enum JSON_FIELDS {
        WIND_HASH,
        DETECTOR_VERSION;

    }
}

