/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.util.impl.RaceColumnListeners;
import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import java.util.Map;

public interface RaceColumn
extends Named {
    public void setRaceLogInformationAndLoad(RaceLogStore var1, RegattaLikeIdentifier var2);

    public void setRaceLogInformation(RaceLogStore var1, RegattaLikeIdentifier var2);

    public RaceLog getRaceLog(Fleet var1);

    public RegattaLog getRegattaLog();

    public Iterable<? extends Fleet> getFleets();

    public Fleet getFleetByName(String var1);

    public Fleet getFleetOfCompetitor(Competitor var1);

    public void setTrackedRace(Fleet var1, TrackedRace var2);

    public boolean hasTrackedRaces();

    public TrackedRace getTrackedRace(Fleet var1);

    default public Fleet getFleetOfTrackedRace(TrackedRace trackedRace) {
        for (Fleet fleet : this.getFleets()) {
            if (this.getTrackedRace(fleet) != trackedRace) continue;
            return fleet;
        }
        return null;
    }

    public RaceDefinition getRaceDefinition(Fleet var1);

    public TrackedRace getTrackedRace(Competitor var1);

    public RaceIdentifier getRaceIdentifier(Fleet var1);

    public void setRaceIdentifier(Fleet var1, RaceIdentifier var2);

    public boolean isMedalRace();

    public Util.Pair<Competitor, RaceColumn> getKey(Competitor var1);

    public RaceColumnListeners getRaceColumnListeners();

    public void removeRaceColumnListener(RaceColumnListener var1);

    public void addRaceColumnListener(RaceColumnListener var1);

    public void releaseTrackedRace(Fleet var1);

    public boolean isStartsWithZeroScore();

    public boolean isDiscardable();

    public boolean isCarryForward();

    public void setFactor(Double var1);

    public Double getExplicitFactor();

    public boolean isOneAlwaysStaysOne();

    public RaceLogIdentifier getRaceLogIdentifier(Fleet var1);

    public void reloadRaceLog(Fleet var1);

    public void removeRaceIdentifier(Fleet var1);

    public void setMasterDataExportOngoingThreadFlag(boolean var1);

    public boolean isTotalOrderDefinedByFleet();

    public boolean hasSplitFleetContiguousScoring();

    public boolean hasCrossFleetMergedRanking();

    public boolean hasSplitFleets();

    public RaceExecutionOrderProvider getRaceExecutionOrderProvider();

    public Iterable<Competitor> getAllCompetitors();

    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered();

    public Iterable<Competitor> getAllCompetitors(Fleet var1);

    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats();

    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats(Fleet var1);

    public Iterable<Mark> getCourseMarks();

    public Iterable<Mark> getCourseMarks(Fleet var1);

    public Iterable<Mark> getAvailableMarks();

    public Iterable<Mark> getAvailableMarks(Fleet var1);

    public Map<Competitor, Boat> getCompetitorsRegisteredInRacelog(Fleet var1);

    public boolean isCompetitorRegistrationInRacelogEnabled(Fleet var1);

    public void enableCompetitorRegistrationOnRaceLog(Fleet var1);

    public void disableCompetitorRegistrationOnRaceLog(Fleet var1) throws NotRevokableException;

    public void registerCompetitor(Competitor var1, Boat var2, Fleet var3) throws CompetitorRegistrationOnRaceLogDisabledException;

    public void registerCompetitors(Map<Competitor, Boat> var1, Fleet var2) throws CompetitorRegistrationOnRaceLogDisabledException;

    public void registerCompetitor(CompetitorWithBoat var1, Fleet var2) throws CompetitorRegistrationOnRaceLogDisabledException;

    public void registerCompetitors(Iterable<CompetitorWithBoat> var1, Fleet var2) throws CompetitorRegistrationOnRaceLogDisabledException;

    public void deregisterCompetitor(Competitor var1, Fleet var2) throws CompetitorRegistrationOnRaceLogDisabledException;

    public void deregisterCompetitors(Iterable<? extends Competitor> var1, Fleet var2) throws CompetitorRegistrationOnRaceLogDisabledException;
}

