/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.DomainFactoryImpl;
import com.sap.sailing.domain.common.Placemark;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorAndBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.PlacemarkDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceStatisticsDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.impl.CourseDesignUpdateHandler;
import com.sap.sailing.domain.tracking.impl.FinishTimeUpdateHandler;
import com.sap.sailing.domain.tracking.impl.RaceAbortedHandler;
import com.sap.sailing.domain.tracking.impl.StartTimeUpdateHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface DomainFactory
extends SharedDomainFactory<RaceLogAndTrackedRaceResolver> {
    public static final RaceLogAndTrackedRaceResolver TEST_RACE_LOG_RESOLVER = new RaceLogAndTrackedRaceResolver(){

        public RaceLog resolve(SimpleRaceLogIdentifier identifier) {
            return null;
        }

        @Override
        public TrackedRace resolveTrackedRace(SimpleRaceLogIdentifier identifier) {
            return null;
        }

        @Override
        public List<Util.Triple<Leaderboard, RaceColumn, Fleet>> getColumnsWithRaceLogForTrackedRace(RegattaAndRaceIdentifier trackedRaceIdentifier) {
            return null;
        }
    };
    public static final DomainFactory INSTANCE = new DomainFactoryImpl(TEST_RACE_LOG_RESOLVER);

    public MarkPassing createMarkPassing(TimePoint var1, Waypoint var2, Competitor var3);

    public ObjectInputStreamResolvingAgainstCache<DomainFactory> createObjectInputStreamResolvingAgainstThisFactory(InputStream var1, ObjectInputStreamResolvingAgainstCache.ResolveListener var2, Map<String, Class<?>> var3) throws IOException;

    public ScoringScheme createScoringScheme(ScoringSchemeType var1);

    public CompetitorDTO convertToCompetitorDTO(Competitor var1);

    public CompetitorWithBoatDTO convertToCompetitorWithBoatDTO(CompetitorWithBoat var1);

    public CompetitorAndBoatDTO convertToCompetitorAndBoatDTO(Competitor var1, Boat var2);

    public Map<CompetitorDTO, BoatDTO> convertToCompetitorAndBoatDTOs(Map<Competitor, ? extends Boat> var1);

    public BoatDTO convertToBoatDTO(Boat var1);

    public FleetDTO convertToFleetDTO(Fleet var1);

    public RaceDTO createRaceDTO(TrackedRegattaRegistry var1, boolean var2, RegattaAndRaceIdentifier var3, TrackedRace var4);

    public PlacemarkDTO convertToPlacemarkDTO(Placemark var1);

    public List<CompetitorDTO> getCompetitorDTOList(Iterable<Competitor> var1);

    public TrackedRaceDTO createTrackedRaceDTO(TrackedRace var1);

    public TrackedRaceStatisticsDTO createTrackedRaceStatisticsDTO(TrackedRace var1, Leaderboard var2, RaceColumn var3, Fleet var4, Iterable<MediaTrack> var5);

    public void updateRaceDTOWithTrackedRaceData(TrackedRace var1, RaceDTO var2);

    public void addUpdateHandlers(DynamicTrackedRace var1, CourseDesignUpdateHandler var2, StartTimeUpdateHandler var3, RaceAbortedHandler var4, FinishTimeUpdateHandler var5);
}

