/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.special.Erf;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.GaussianDistribution;

public class LogNormalDistribution
extends AbstractDistribution {
    private static final long serialVersionUID = 1L;
    private double mu;
    private double sigma;
    private double mean;
    private double var;
    private double entropy;
    private GaussianDistribution gaussian;

    public LogNormalDistribution(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Invalid sigma: " + sigma);
        }
        this.mu = mu;
        this.sigma = sigma;
        this.mean = smile.math.Math.exp(mu + sigma * sigma / 2.0);
        this.var = (smile.math.Math.exp(mu * mu) - 1.0) * smile.math.Math.exp(2.0 * mu + sigma * sigma);
        this.entropy = 0.5 + 0.5 * smile.math.Math.log(Math.PI * 2 * sigma * sigma) + mu;
    }

    public LogNormalDistribution(double[] data) {
        double[] x = new double[data.length];
        for (int i = 0; i < x.length; ++i) {
            if (data[i] <= 0.0) {
                throw new IllegalArgumentException("Invalid input data: " + data[i]);
            }
            x[i] = smile.math.Math.log(data[i]);
        }
        this.mu = smile.math.Math.mean(x);
        this.sigma = smile.math.Math.sd(x);
        this.mean = smile.math.Math.exp(this.mu + this.sigma * this.sigma / 2.0);
        this.var = (smile.math.Math.exp(this.mu * this.mu) - 1.0) * smile.math.Math.exp(2.0 * this.mu + this.sigma * this.sigma);
        this.entropy = 0.5 + 0.5 * smile.math.Math.log(Math.PI * 2 * this.sigma * this.sigma) + this.mu;
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public int npara() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double var() {
        return this.var;
    }

    @Override
    public double sd() {
        return smile.math.Math.sqrt(this.var);
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Log Normal Distribution(%.4f, %.4f)", this.mu, this.sigma);
    }

    @Override
    public double rand() {
        if (this.gaussian == null) {
            this.gaussian = new GaussianDistribution(this.mu, this.sigma);
        }
        return smile.math.Math.exp(this.gaussian.rand());
    }

    @Override
    public double p(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        double t = (smile.math.Math.log(x) - this.mu) / this.sigma;
        return 0.3989422804014327 / (this.sigma * x) * smile.math.Math.exp(-0.5 * t * t);
    }

    @Override
    public double logp(double x) {
        return smile.math.Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        if (x == 0.0) {
            return 0.0;
        }
        return 0.5 * Erf.erfc(-0.7071067811865476 * (smile.math.Math.log(x) - this.mu) / this.sigma);
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return smile.math.Math.exp(-1.4142135623730951 * this.sigma * Erf.inverfc(2.0 * p) + this.mu);
    }
}

