/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.domain.common.dto.ExpeditionAllInOneConstants;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapterFactory;
import com.sap.sailing.server.gateway.impl.AbstractFileUploadServlet;
import com.sap.sailing.server.gateway.trackfiles.impl.AllInOneImportException;
import com.sap.sailing.server.gateway.trackfiles.impl.ExpeditionAllInOneImporter;
import com.sap.sailing.server.gateway.trackfiles.impl.ImportResultSerializer;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import com.sap.sse.util.ServiceTrackerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ExpeditionAllInOneImportServlet
extends AbstractFileUploadServlet {
    private static final long serialVersionUID = 1120226743039934620L;
    private static final Logger logger = Logger.getLogger(ExpeditionAllInOneImportServlet.class.getName());
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private ServiceTracker<RaceLogTrackingAdapterFactory, RaceLogTrackingAdapterFactory> raceLogTrackingAdapterTracker;
    private ResourceBundleStringMessages serverStringMessages;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.raceLogTrackingAdapterTracker = ServiceTrackerFactory.createAndOpen((BundleContext)this.getContext(), RaceLogTrackingAdapterFactory.class);
        this.serverStringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, ((Object)((Object)this)).getClass().getClassLoader(), StandardCharsets.UTF_8.name());
    }

    @Override
    protected void process(List<FileItem> fileItems, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block25: {
            ExpeditionAllInOneImporter.ImporterResult importerResult = null;
            try {
                ExpeditionAllInOneConstants.ImportMode importMode;
                Locale uiLocale;
                String fileName = null;
                FileItem fileItem = null;
                String boatClassName = null;
                String regattaName = null;
                String importModeName = null;
                String localeName = null;
                boolean importStartData = false;
                for (FileItem fi : fileItems) {
                    if (!fi.isFormField()) {
                        fileName = fi.getName();
                        fileItem = fi;
                        continue;
                    }
                    if (fi.getFieldName() == null) continue;
                    if ("boatClass".equals(fi.getFieldName())) {
                        boatClassName = fi.getString();
                    }
                    if ("regattaName".equals(fi.getFieldName())) {
                        regattaName = fi.getString();
                    }
                    if ("importMode".equals(fi.getFieldName())) {
                        importModeName = fi.getString();
                    }
                    if ("locale".equals(fi.getFieldName())) {
                        localeName = fi.getString();
                    }
                    if (!"importStartData".equals(fi.getFieldName())) continue;
                    importStartData = fi.getString().equalsIgnoreCase("on");
                }
                if (localeName == null) {
                    uiLocale = Locale.ENGLISH;
                } else {
                    try {
                        uiLocale = Locale.forLanguageTag(localeName);
                    }
                    catch (Exception e) {
                        uiLocale = Locale.ENGLISH;
                    }
                }
                if (fileItem == null) {
                    throw new AllInOneImportException(this.serverStringMessages.get(uiLocale, "allInOneErrorImportFileMissing"));
                }
                if (importModeName == null) {
                    importMode = ExpeditionAllInOneConstants.ImportMode.NEW_EVENT;
                } else {
                    try {
                        importMode = ExpeditionAllInOneConstants.ImportMode.valueOf(importModeName);
                    }
                    catch (Exception e) {
                        throw new AllInOneImportException(this.serverStringMessages.get(uiLocale, "allInOneErrorUnknownImportMode"));
                    }
                }
                if (importMode == ExpeditionAllInOneConstants.ImportMode.NEW_EVENT) {
                    if (boatClassName == null || boatClassName.isEmpty()) {
                        throw new AllInOneImportException(this.serverStringMessages.get(uiLocale, "allInOneErrorMissingBoatClass"));
                    }
                } else if (regattaName == null || regattaName.isEmpty()) {
                    throw new AllInOneImportException(this.serverStringMessages.get(uiLocale, "allInOneErrorMissingRegattaClass"));
                }
                importerResult = new ExpeditionAllInOneImporter(this.serverStringMessages, uiLocale, this.getService(), this.getSecurityService(), this.getRaceLogTrackingAdapter(), this.getServiceFinderFactory(), this.getContext()).importFiles(fileName, fileItem, boatClassName, importMode, regattaName, importStartData);
            }
            catch (AllInOneImportException e) {
                importerResult = new ExpeditionAllInOneImporter.ImporterResult(e, e.additionalErrors);
                logger.log(Level.SEVERE, e.getMessage());
                this.writeJsonIntoHtmlResponse(resp, (JSONAware)this.toJSON(importerResult));
                break block25;
            }
            catch (Throwable t) {
                try {
                    importerResult = new ExpeditionAllInOneImporter.ImporterResult(t, Collections.emptyList());
                    logger.log(Level.SEVERE, t.getMessage());
                }
                catch (Throwable throwable) {
                    this.writeJsonIntoHtmlResponse(resp, (JSONAware)this.toJSON(importerResult));
                    throw throwable;
                }
                this.writeJsonIntoHtmlResponse(resp, (JSONAware)this.toJSON(importerResult));
                break block25;
            }
            this.writeJsonIntoHtmlResponse(resp, (JSONAware)this.toJSON(importerResult));
        }
    }

    private RaceLogTrackingAdapter getRaceLogTrackingAdapter() {
        return ((RaceLogTrackingAdapterFactory)this.raceLogTrackingAdapterTracker.getService()).getAdapter(this.getService().getBaseDomainFactory());
    }

    private JSONObject toJSON(ExpeditionAllInOneImporter.ImporterResult importerResult) {
        JSONObject json = new JSONObject();
        json.put((Object)"eventId", importerResult.eventId == null ? null : importerResult.eventId.toString());
        json.put((Object)"leaderboardName", (Object)importerResult.leaderboardName);
        json.put((Object)"leaderboardGroupName", (Object)importerResult.leaderboardGroupName);
        json.put((Object)"regattaName", (Object)importerResult.regattaName);
        json.put((Object)"raceNameRaceColumnNameFleetNameList", (Object)ImportResultSerializer.serializeRaceList(importerResult.raceNameRaceColumnNameFleetnameList));
        json.put((Object)"errors", (Object)ImportResultSerializer.serializeErrorList(importerResult.errorList));
        json.put((Object)"gpsDeviceIds", (Object)ImportResultSerializer.serializeTrackList(importerResult.importGpsFixData));
        json.put((Object)"sensorDeviceIds", (Object)ImportResultSerializer.serializeTrackList(importerResult.importSensorFixData));
        json.put((Object)"sensorFixImporterType", (Object)importerResult.sensorFixImporterType);
        json.put((Object)"startTimes", importerResult.startData == null ? null : ImportResultSerializer.serializeIterable(importerResult.startData.getStartTimes(), startTime -> startTime.asMillis()));
        return json;
    }
}

