/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.server.gateway.deserialization.impl.Helpers;
import com.sap.sailing.server.impl.preferences.model.TrackedElementWithDeviceId;
import com.sap.sailing.server.impl.preferences.model.TrackedEventPreference;
import com.sap.sailing.server.impl.preferences.model.TrackedEventPreferences;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.shared.json.JsonDeserializationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

@Path(value="/v1/trackedevents/")
public class TrackedEventsResource
extends AbstractSailingServerResource {
    protected static final Logger logger = Logger.getLogger(TrackedEventsResource.class.getName());
    private static final String KEY_QUERY_INCLUDE_ARCHIVED = "includeArchived";
    private static final String KEY_LEADERBOARD_NAME = "leaderboardName";
    private static final String KEY_EVENT_ID = "eventId";
    private static final String KEY_EVENT_IS_ARCHIVED = "isArchived";
    private static final String KEY_EVENT_TRACKED_ELEMENTS = "trackedElements";
    private static final String KEY_EVENT_BASE_URL = "url";
    private static final String KEY_EVENT_REGATTA_SECRET = "regattaSecret";
    private static final String KEY_TRACKED_ELEMENT_DEVICE_ID = "deviceId";
    private static final String KEY_TRACKED_ELEMENT_COMPETITOR_ID = "competitorId";
    private static final String KEY_TRACKED_ELEMENT_BOAT_ID = "boatId";
    private static final String KEY_TRACKED_ELEMENT_MARK_ID = "markId";
    private static final String KEY_TRACKED_EVENTS = "trackedEvents";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getTrackedEvents(@QueryParam(value="includeArchived") String includeArchivedStr) {
        Response.ResponseBuilder builder;
        User currentUser = this.getSecurityService().getCurrentUser();
        if (currentUser != null) {
            TrackedEventPreferences prefs = (TrackedEventPreferences)this.getSecurityService().getPreferenceObject(currentUser.getName(), "sailing.profile.trackedevents");
            JSONArray result = new JSONArray();
            boolean includeArchived = Boolean.parseBoolean(includeArchivedStr);
            if (prefs != null) {
                for (TrackedEventPreference pref : prefs.getTrackedEvents()) {
                    if (pref == null) {
                        logger.warning("null entry in TrackedEventPreferences list: " + prefs.toString());
                        continue;
                    }
                    if (!includeArchived && pref.getIsArchived()) continue;
                    JSONObject jsonEvent = new JSONObject();
                    jsonEvent.put((Object)KEY_EVENT_ID, (Object)pref.getEventId().toString());
                    jsonEvent.put((Object)KEY_EVENT_REGATTA_SECRET, (Object)pref.getRegattaSecret());
                    jsonEvent.put((Object)KEY_EVENT_BASE_URL, (Object)pref.getBaseUrl());
                    jsonEvent.put((Object)KEY_EVENT_IS_ARCHIVED, (Object)pref.getIsArchived());
                    jsonEvent.put((Object)KEY_LEADERBOARD_NAME, (Object)pref.getLeaderboardName());
                    jsonEvent.put((Object)KEY_EVENT_TRACKED_ELEMENTS, (Object)this.trackedElementsToJson(pref));
                    result.add((Object)jsonEvent);
                }
            }
            JSONObject resultEvents = new JSONObject();
            resultEvents.put((Object)KEY_TRACKED_EVENTS, (Object)result);
            builder = Response.ok((Object)this.streamingOutput(resultEvents));
        } else {
            builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        return builder.build();
    }

    private JSONArray trackedElementsToJson(TrackedEventPreference pref) {
        JSONArray deviceIdsWithTrackedElementJson = new JSONArray();
        for (TrackedElementWithDeviceId trackedElement : pref.getTrackedElements()) {
            JSONObject trackedElementJson = new JSONObject();
            trackedElementJson.put((Object)KEY_TRACKED_ELEMENT_DEVICE_ID, (Object)trackedElement.getDeviceId());
            if (trackedElement.getTrackedCompetitorId() != null) {
                trackedElementJson.put((Object)KEY_TRACKED_ELEMENT_COMPETITOR_ID, (Object)trackedElement.getTrackedCompetitorId().toString());
            } else if (trackedElement.getTrackedBoatId() != null) {
                trackedElementJson.put((Object)KEY_TRACKED_ELEMENT_BOAT_ID, (Object)trackedElement.getTrackedBoatId().toString());
            } else if (trackedElement.getTrackedMarkId() != null) {
                trackedElementJson.put((Object)KEY_TRACKED_ELEMENT_MARK_ID, (Object)trackedElement.getTrackedMarkId().toString());
            }
            deviceIdsWithTrackedElementJson.add((Object)trackedElementJson);
        }
        return deviceIdsWithTrackedElementJson;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="{eventId}/{leaderboardName}")
    public Response updateOrCreateTrackedEvent(@PathParam(value="eventId") String eventId, @PathParam(value="leaderboardName") String leaderboardName, String jsonBody) {
        Response.ResponseBuilder responseBuilder = null;
        User currentUser = this.getSecurityService().getCurrentUser();
        if (currentUser != null) {
            try {
                Object requestBody = JSONValue.parseWithException((String)jsonBody);
                JSONObject requestObject = Helpers.toJSONObjectSafe((Object)requestBody);
                Boolean archived = (Boolean)requestObject.get((Object)KEY_EVENT_IS_ARCHIVED);
                String baseUrl = (String)requestObject.get((Object)KEY_EVENT_BASE_URL);
                String regattaSecret = (String)requestObject.get((Object)KEY_EVENT_REGATTA_SECRET);
                try {
                    UUID uuidEvent = UUID.fromString(eventId);
                    boolean isArchived = archived;
                    TrackedEventPreferences prefs = (TrackedEventPreferences)this.getSecurityService().getPreferenceObject(currentUser.getName(), "sailing.profile.trackedevents");
                    if (prefs == null) {
                        prefs = new TrackedEventPreferences();
                    }
                    JSONArray trackedElementsJson = (JSONArray)requestObject.get((Object)KEY_EVENT_TRACKED_ELEMENTS);
                    Collection prefsNew = StreamSupport.stream(prefs.getTrackedEvents().spliterator(), false).filter(pref -> !pref.getEventId().equals(uuidEvent) || !pref.getLeaderboardName().equals(leaderboardName)).collect(Collectors.toList());
                    ArrayList<TrackedElementWithDeviceId> trackedElements = new ArrayList<TrackedElementWithDeviceId>();
                    if (trackedElementsJson != null) {
                        for (Object trackedElementObject : trackedElementsJson) {
                            UUID markId;
                            JSONObject jsonTrackedElement = (JSONObject)trackedElementObject;
                            String deviceId = (String)jsonTrackedElement.get((Object)KEY_TRACKED_ELEMENT_DEVICE_ID);
                            String competitorIdStr = (String)jsonTrackedElement.get((Object)KEY_TRACKED_ELEMENT_COMPETITOR_ID);
                            String boatIdStr = (String)jsonTrackedElement.get((Object)KEY_TRACKED_ELEMENT_BOAT_ID);
                            String markIdStr = (String)jsonTrackedElement.get((Object)KEY_TRACKED_ELEMENT_MARK_ID);
                            UUID competitorId = this.parseUUID(competitorIdStr);
                            UUID boatId = this.parseUUID(boatIdStr);
                            if (boatId != null ^ (markId = this.parseUUID(markIdStr)) != null ^ competitorId != null) {
                                TrackedElementWithDeviceId newPrefElem = new TrackedElementWithDeviceId(deviceId, boatId, competitorId, markId);
                                trackedElements.add(newPrefElem);
                                continue;
                            }
                            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request.");
                        }
                    }
                    TrackedEventPreference newPreference = new TrackedEventPreference(uuidEvent, leaderboardName, trackedElements, baseUrl, isArchived, regattaSecret);
                    prefsNew.add(newPreference);
                    prefs.setTrackedEvents((Iterable)prefsNew);
                    this.getSecurityService().setPreferenceObject(currentUser.getName(), "sailing.profile.trackedevents", (Object)prefs);
                    responseBuilder = Response.status((Response.Status)Response.Status.ACCEPTED);
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid or missing attributes in JSON body.");
                }
            }
            catch (JsonDeserializationException | ParseException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON body in request.");
            }
        } else {
            responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        return responseBuilder.build();
    }

    private UUID parseUUID(String potentialUUID) {
        UUID uuid;
        if (potentialUUID != null && !potentialUUID.isEmpty()) {
            try {
                uuid = UUID.fromString(potentialUUID);
            }
            catch (IllegalArgumentException e) {
                uuid = null;
            }
        } else {
            uuid = null;
        }
        return uuid;
    }

    @POST
    @Path(value="{eventId}/{leaderboardName}")
    public Response updateTrackedEventsArchivedStatus(@PathParam(value="eventId") String eventId, @PathParam(value="leaderboardName") String leaderboardName, @FormParam(value="includeArchived") String archived) {
        boolean isArchived = Boolean.parseBoolean(archived);
        return this.applyOnEventByIdAndLeadboardName(eventId, leaderboardName, pref -> new TrackedEventPreference(pref, isArchived));
    }

    @DELETE
    @Path(value="{eventId}/{leaderboardName}")
    public Response deleteTrackedEvents(@PathParam(value="eventId") String eventId, @PathParam(value="leaderboardName") String leaderboardName) {
        return this.applyOnEventByIdAndLeadboardName(eventId, leaderboardName, pref -> null);
    }

    private Response applyOnEventByIdAndLeadboardName(String eventId, String leaderboardName, Function<TrackedEventPreference, TrackedEventPreference> function) {
        Response.ResponseBuilder responseBuilder;
        block8: {
            User currentUser = this.getSecurityService().getCurrentUser();
            if (currentUser != null) {
                TrackedEventPreferences prefs = (TrackedEventPreferences)this.getSecurityService().getPreferenceObject(currentUser.getName(), "sailing.profile.trackedevents");
                try {
                    UUID eventUuid = UUID.fromString(eventId);
                    if (prefs == null) {
                        responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No tracked events with this eventId found.");
                        break block8;
                    }
                    boolean found = false;
                    HashSet<TrackedEventPreference> newPrefs = new HashSet<TrackedEventPreference>();
                    for (TrackedEventPreference pref : prefs.getTrackedEvents()) {
                        if (pref.getEventId().equals(eventUuid) && pref.getLeaderboardName().equals(leaderboardName)) {
                            found = true;
                            TrackedEventPreference updatedPreference = function.apply(pref);
                            if (updatedPreference == null) continue;
                            newPrefs.add(updatedPreference);
                            continue;
                        }
                        newPrefs.add(pref);
                    }
                    if (!found) {
                        responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No tracked events with this eventId found.");
                        break block8;
                    }
                    prefs.setTrackedEvents(newPrefs);
                    this.getSecurityService().setPreferenceObject(currentUser.getName(), "sailing.profile.trackedevents", (Object)prefs);
                    responseBuilder = Response.status((Response.Status)Response.Status.ACCEPTED);
                }
                catch (IllegalArgumentException e) {
                    responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid eventId.");
                }
            } else {
                responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
            }
        }
        return responseBuilder.build();
    }
}

