/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.polars.windestimation.ManeuverBasedWindEstimationTrackImpl;
import com.sap.sailing.server.gateway.serialization.impl.PositionJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.WindJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.json.JsonSerializer;
import com.sap.sse.util.kmeans.Cluster;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.json.simple.JSONArray;

@Path(value="/v1/polars")
public class PolarResource
extends AbstractSailingServerResource {
    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="{boatClassName}")
    public Response getSpeed(@PathParam(value="boatClassName") String boatClassName, @QueryParam(value="angle") double angle, @QueryParam(value="windspeedInKnots") double windSpeed) {
        Response.ResponseBuilder responseBuilder;
        BoatClass boatClass = this.getService().getDomainObjectFactory().getBaseDomainFactory().getOrCreateBoatClass(boatClassName);
        try {
            SpeedWithConfidence speedWithConfidence = this.getService().getPolarDataService().getSpeed(boatClass, (Speed)new KnotSpeedImpl(windSpeed), (Bearing)new DegreeBearingImpl(angle));
            String resultString = "Speed: " + ((Speed)speedWithConfidence.getObject()).getKnots() + "kn; Confidence: " + speedWithConfidence.getConfidence();
            responseBuilder = Response.ok((Object)resultString, (String)"text/plain");
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            responseBuilder = Response.noContent();
        }
        return responseBuilder.build();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="functions")
    public Response getFunctions() {
        PolarDataService polarDataService = this.getService().getPolarDataService();
        Set boatClasses = polarDataService.getAllBoatClassesWithPolarSheetsAvailable();
        StringBuilder stringBuilder = new StringBuilder();
        for (BoatClass boatClass : boatClasses) {
            LegType[] legTypeArray = new LegType[]{LegType.UPWIND, LegType.DOWNWIND};
            int n = legTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LegType legType = legTypeArray[n2];
                try {
                    PolynomialFunction speedFunction = polarDataService.getSpeedRegressionFunction(boatClass, legType);
                    stringBuilder.append("Speed: " + boatClass + " " + legType + ": " + speedFunction.toString() + "\n");
                    PolynomialFunction angleFunction = polarDataService.getAngleRegressionFunction(boatClass, legType);
                    stringBuilder.append("Angle: " + boatClass + " " + legType + ": " + angleFunction.toString() + "\n");
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    stringBuilder.append("No data for " + boatClass + " " + legType + "\n");
                }
                ++n2;
            }
            double trueWindAngle = -177.5;
            while (trueWindAngle < 180.0) {
                try {
                    PolynomialFunction speedForTWAFunction = polarDataService.getSpeedRegressionFunction(boatClass, trueWindAngle);
                    stringBuilder.append("Speed for TWA: " + boatClass + " " + trueWindAngle + ": " + speedForTWAFunction.toString() + "\n");
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    stringBuilder.append("No data for " + boatClass + " " + trueWindAngle + "\n");
                }
                trueWindAngle += 5.0;
            }
            stringBuilder.append("\n\n");
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)stringBuilder.toString(), (String)"text/plain");
        return responseBuilder.build();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="average/{boatClassName}")
    public Response getAverageSpeedAndBearing(@PathParam(value="boatClassName") String boatClassName, @QueryParam(value="windspeedInKnots") double wSpeed, @QueryParam(value="legtype") LegType legType, @QueryParam(value="tack") Tack tack) {
        Response.ResponseBuilder responseBuilder;
        BoatClass boatClass = this.getService().getDomainObjectFactory().getBaseDomainFactory().getOrCreateBoatClass(boatClassName);
        KnotSpeedImpl windSpeed = new KnotSpeedImpl(wSpeed);
        try {
            PolarDataService service = this.getService().getPolarDataService();
            SpeedWithBearingWithConfidence speedWithBearing = service.getAverageSpeedWithTrueWindAngle(boatClass, (Speed)windSpeed, legType, tack);
            String resultString = "Speed: " + speedWithBearing.getObject().getKnots() + "kn; Angle: " + speedWithBearing.getObject().getBearing().getDegrees() + "\u00b0; Confidence: " + speedWithBearing.getConfidence();
            responseBuilder = Response.ok((Object)resultString, (String)"text/plain");
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            responseBuilder = Response.noContent();
        }
        return responseBuilder.build();
    }

    private Response getBadRegattaErrorResponse(String regattaName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a regatta with name '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    private Response getBadRaceErrorResponse(String regattaName, String raceName) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a race with name '" + StringEscapeUtils.escapeHtml((String)raceName) + "' in regatta '" + StringEscapeUtils.escapeHtml((String)regattaName) + "'.")).type("text/plain").build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="windestimation/{regattaname}/races/{racename}")
    public Response getCompetitorPositions(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName) throws NotEnoughDataHasBeenAddedException {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                JSONArray resultAsJson = new JSONArray();
                WindJsonSerializer serializer = new WindJsonSerializer((JsonSerializer)new PositionJsonSerializer());
                PolarDataService service = this.getService().getPolarDataService();
                ManeuverBasedWindEstimationTrackImpl maneuverBasedWindEstimationTrackImpl = new ManeuverBasedWindEstimationTrackImpl(service, trackedRace, 30000L, false);
                maneuverBasedWindEstimationTrackImpl.initialize();
                maneuverBasedWindEstimationTrackImpl.lockForRead();
                try {
                    for (Wind wind : maneuverBasedWindEstimationTrackImpl.getFixes()) {
                        resultAsJson.add((Object)serializer.serialize(wind));
                    }
                }
                finally {
                    maneuverBasedWindEstimationTrackImpl.unlockAfterRead();
                }
                response = Response.ok((Object)this.streamingOutput(resultAsJson)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
            }
        }
        return response;
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="maneuvers/{regattaname}/races/{racename}")
    public Response getManeuvers(@PathParam(value="regattaname") String regattaName, @PathParam(value="racename") String raceName, @QueryParam(value="cluster") String cluster) throws NotEnoughDataHasBeenAddedException {
        Response response;
        Regatta regatta = this.findRegattaByName(regattaName);
        if (regatta == null) {
            response = this.getBadRegattaErrorResponse(regattaName);
        } else {
            this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)regatta);
            RaceDefinition race = this.findRaceByName(regatta, raceName);
            if (race == null) {
                response = this.getBadRaceErrorResponse(regattaName, raceName);
            } else {
                TrackedRace trackedRace = this.findTrackedRace(regattaName, raceName);
                PolarDataService service = this.getService().getPolarDataService();
                ManeuverBasedWindEstimationTrackImpl maneuverBasedWindEstimationTrackImpl = new ManeuverBasedWindEstimationTrackImpl(service, trackedRace, 30000L, false);
                Stream<Object> clusters = "tack".equals(cluster) ? maneuverBasedWindEstimationTrackImpl.getTackClusters().stream() : ("jibe".equals(cluster) ? maneuverBasedWindEstimationTrackImpl.getJibeClusters().stream() : (cluster != null && cluster.matches("[0-9][0-9]*") ? Stream.of((Cluster)new ArrayList(maneuverBasedWindEstimationTrackImpl.getClusters()).get(Integer.valueOf(cluster))) : maneuverBasedWindEstimationTrackImpl.getClusters().stream()));
                response = Response.ok((Object)maneuverBasedWindEstimationTrackImpl.getStringRepresentation(clusters), (String)"text/plain").build();
            }
        }
        return response;
    }
}

