/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentResources;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;

public class ComponentToolbarEntry<SettingsType extends AbstractSettings>
extends HorizontalPanel {
    private static ComponentResources resources = (ComponentResources)GWT.create(ComponentResources.class);
    private final Component<SettingsType> component;
    private final StringMessages stringMessages;

    public ComponentToolbarEntry(Component<SettingsType> component, StringMessages stringMessages) {
        this.setSpacing(10);
        this.component = component;
        this.stringMessages = stringMessages;
    }

    public void addSettingsButton() {
        if (this.component.hasSettings()) {
            ImageResource settingsImage = resources.darkSettingsIcon();
            Anchor showConfigAnchor = new Anchor(AbstractImagePrototype.create((ImageResource)settingsImage).getSafeHtml());
            showConfigAnchor.setTitle(this.stringMessages.configuration());
            showConfigAnchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    new SettingsDialog(ComponentToolbarEntry.this.component, ComponentToolbarEntry.this.stringMessages).show();
                }
            });
            this.add((Widget)showConfigAnchor);
        }
    }
}

