/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.GenericStringListInlineEditorComposite;
import java.util.ArrayList;
import java.util.List;

public class ExpandedUiWithCheckboxes<ValueType>
extends GenericStringListInlineEditorComposite.ExpandedUi<ValueType> {
    private final List<CheckBox> checkBoxes;
    private final String checkBoxText;
    private final List<ChangeHandler> changeHandler = new ArrayList<ChangeHandler>();
    static final ListEditorResources ress = (ListEditorResources)GWT.create(ListEditorResources.class);

    public ExpandedUiWithCheckboxes(StringMessages stringMessages, ImageResource removeImage, Iterable<String> suggestValues, String placeholderTextForAddTextbox, int textBoxSize, String checkBoxText) {
        super(stringMessages, removeImage, suggestValues, placeholderTextForAddTextbox, textBoxSize);
        this.checkBoxes = new ArrayList<CheckBox>();
        this.checkBoxText = checkBoxText;
        ress.css().ensureInjected();
    }

    public List<CheckBox> getCheckBoxes() {
        return this.checkBoxes;
    }

    public static String getInvisibleStyle() {
        return ress.css().checkBoxInvisible();
    }

    public static String getErrorStyle() {
        return ress.css().checkBoxError();
    }

    public static String getNormalStyle() {
        return ress.css().checkBoxNormal();
    }

    @Override
    protected void addRow(ValueType newValue) {
        super.addRow(newValue);
        CheckBox checkBox = new CheckBox(this.checkBoxText);
        checkBox.setStylePrimaryName(ExpandedUiWithCheckboxes.getInvisibleStyle());
        checkBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CheckBox source = (CheckBox)event.getSource();
                if (source.getValue().booleanValue()) {
                    source.setStylePrimaryName(ExpandedUiWithCheckboxes.getNormalStyle());
                } else {
                    source.setStylePrimaryName(ExpandedUiWithCheckboxes.getErrorStyle());
                }
                for (ChangeHandler changeHandler : ExpandedUiWithCheckboxes.this.changeHandler) {
                    changeHandler.onChange(null);
                }
            }
        });
        this.checkBoxes.add(checkBox);
        this.expandedValuesGrid.setWidget(this.expandedValuesGrid.getRowCount() - 1, 2, (Widget)checkBox);
    }

    @Override
    public Widget initWidget() {
        this.expandedValuesGrid = new Grid(0, 3);
        this.expandedValuesGrid.ensureDebugId("ExpandedValuesGrid");
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.createAddWidget());
        panel.add((Widget)this.expandedValuesGrid);
        return panel;
    }

    @Override
    public void onRowRemoved(int rowIndex) {
        this.checkBoxes.remove(rowIndex);
    }

    public void addChangeHandler(ChangeHandler handler) {
        this.changeHandler.add(handler);
    }

    static interface ListEditorCSS
    extends CssResource {
        public String checkBoxInvisible();

        public String checkBoxNormal();

        public String checkBoxError();
    }

    static interface ListEditorResources
    extends ClientBundle {
        @ClientBundle.Source(value={"ListEditor.gss"})
        public ListEditorCSS css();
    }
}

