/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.ui.client.presentation.AbstractNumericResultsPresenter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlainResultsPresenter
extends AbstractNumericResultsPresenter<Settings> {
    private static final String htmlWhitespace = "&nbsp;";
    private final ScrollPanel scrollPanel;
    private final HTML resultsLabel;
    private final LinkedHashSet<String> signifiers = new LinkedHashSet();
    private final Map<GroupKey, Map<String, Number>> results = new HashMap<GroupKey, Map<String, Number>>();

    public PlainResultsPresenter(Component<?> parent, ComponentContext<?> context) {
        super(parent, context);
        this.resultsLabel = new HTML();
        this.scrollPanel = new ScrollPanel((Widget)this.resultsLabel);
    }

    @Override
    protected void internalShowNumericResults(Map<GroupKey, Number> resultValues, Map<GroupKey, Util.Triple<Number, Number, Long>> errorMargins) {
        this.signifiers.clear();
        this.results.clear();
        String currentSignifier = this.getCurrentResult().getResultSignifier();
        this.signifiers.add(currentSignifier);
        for (Map.Entry<GroupKey, Number> entry : resultValues.entrySet()) {
            Map<String, Number> values = this.results.get(entry.getKey());
            if (values == null) {
                values = new HashMap<String, Number>();
                this.results.put(entry.getKey(), values);
            }
            values.put(currentSignifier, entry.getValue());
        }
        SafeHtmlBuilder displayBuilder = new SafeHtmlBuilder();
        if (this.signifiers.size() == 1) {
            displayBuilder.appendHtmlConstant("<b>").appendEscaped(this.getCurrentResult().getResultSignifier()).appendHtmlConstant("</b>").appendHtmlConstant("<br />");
        }
        displayBuilder.appendHtmlConstant("<table>");
        if (this.signifiers.size() > 1) {
            this.buildTableForMultipleSignifiers(displayBuilder);
        } else if (this.areCollectedResultsTwoDimensional()) {
            this.buildTableForTwoDimensionalResult(displayBuilder);
        } else {
            this.buildList(displayBuilder);
        }
        displayBuilder.appendHtmlConstant("</table>");
        this.resultsLabel.setHTML(displayBuilder.toSafeHtml().asString());
    }

    private boolean areCollectedResultsTwoDimensional() {
        for (GroupKey key : this.results.keySet()) {
            if (key.size() == 2) continue;
            return false;
        }
        return true;
    }

    private void buildTableForMultipleSignifiers(SafeHtmlBuilder displayBuilder) {
        this.buildTableHeader(this.signifiers, displayBuilder);
        for (GroupKey key : this.getSortedKeys(this.results.keySet())) {
            this.buildTableRow(key, this.signifiers, this.results.get(key), displayBuilder);
        }
    }

    private void buildTableForTwoDimensionalResult(SafeHtmlBuilder displayBuilder) {
        Map<GroupKey, Map<GroupKey, Number>> unfoldedResultValues = this.unfoldResultValues();
        HashSet<GroupKey> allSubKeys = new HashSet<GroupKey>();
        unfoldedResultValues.forEach((key, values) -> {
            boolean bl = allSubKeys.addAll(values.keySet());
        });
        Iterable<GroupKey> sortedSubKeys = this.getSortedKeys(allSubKeys);
        this.buildTableHeader(sortedSubKeys, displayBuilder);
        for (GroupKey mainKey : this.getSortedKeys(unfoldedResultValues.keySet())) {
            this.buildTableRow(mainKey, sortedSubKeys, unfoldedResultValues.get(mainKey), displayBuilder);
        }
    }

    private void buildTableHeader(Iterable<?> columnHeaders, SafeHtmlBuilder displayBuilder) {
        displayBuilder.appendHtmlConstant("<tr><th>&nbsp;</th>");
        for (Object columnHeader : columnHeaders) {
            displayBuilder.appendHtmlConstant("<th>").appendEscaped(columnHeader.toString()).appendHtmlConstant("</th>");
        }
        displayBuilder.appendHtmlConstant("</tr>");
    }

    private void buildTableRow(GroupKey rowKey, Iterable<?> orderedColumnKeys, Map<?, Number> columnValues, SafeHtmlBuilder displayBuilder) {
        displayBuilder.appendHtmlConstant("<tr>");
        displayBuilder.appendHtmlConstant("<td><b>").appendEscaped(rowKey + ":").appendHtmlConstant("</b></td>");
        for (Object columnKey : orderedColumnKeys) {
            Number value = columnValues.get(columnKey);
            displayBuilder.appendHtmlConstant("<td>");
            if (value != null) {
                displayBuilder.append(value.doubleValue());
            }
            displayBuilder.appendHtmlConstant("</td>");
        }
        displayBuilder.appendHtmlConstant("</tr>");
    }

    private Map<GroupKey, Map<GroupKey, Number>> unfoldResultValues() {
        String signifier = (String)Util.first(this.signifiers);
        HashMap<GroupKey, Map<GroupKey, Number>> unfoldedResultValues = new HashMap<GroupKey, Map<GroupKey, Number>>();
        for (Map.Entry<GroupKey, Map<String, Number>> entry : this.results.entrySet()) {
            List keys = entry.getKey().getKeys();
            GroupKey mainKey = (GroupKey)keys.get(0);
            GroupKey subKey = (GroupKey)keys.get(1);
            HashMap<GroupKey, Number> values = (HashMap<GroupKey, Number>)unfoldedResultValues.get(mainKey);
            if (values == null) {
                values = new HashMap<GroupKey, Number>();
                unfoldedResultValues.put(mainKey, values);
            }
            values.put(subKey, entry.getValue().get(signifier));
        }
        return unfoldedResultValues;
    }

    private void buildList(SafeHtmlBuilder displayBuilder) {
        String signifier = (String)Util.first(this.signifiers);
        for (GroupKey key : this.getSortedKeys(this.results.keySet())) {
            displayBuilder.appendHtmlConstant("<tr>");
            displayBuilder.appendHtmlConstant("<td><b>").appendEscaped(key + ":").appendHtmlConstant("</b></td>");
            displayBuilder.appendHtmlConstant("<td>").append(this.results.get(key).get(signifier).doubleValue()).appendHtmlConstant("</td>");
            displayBuilder.appendHtmlConstant("</tr>");
        }
    }

    private Iterable<GroupKey> getSortedKeys(Set<GroupKey> keys) {
        ArrayList<GroupKey> sortedKeys = new ArrayList<GroupKey>(keys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    @Override
    protected Widget getPresentationWidget() {
        return this.scrollPanel;
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().plainResultsPresenter();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public String getDependentCssClassName() {
        return "plainResultsPresenter";
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "prp";
    }
}

