/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.ReplicationCredentials;
import com.sap.sse.landscape.UserDataProvider;
import com.sap.sse.landscape.impl.InboundReplicationConfigurationImpl;
import com.sap.sse.landscape.rabbitmq.RabbitMQEndpoint;
import java.util.HashMap;
import java.util.Map;

public interface InboundReplicationConfiguration
extends UserDataProvider {
    public static Builder builder() {
        return new InboundReplicationConfigurationImpl.BuilderImpl();
    }

    public static Builder copy(InboundReplicationConfiguration inboundReplicationConfiguration) {
        return new InboundReplicationConfigurationImpl.BuilderImpl(inboundReplicationConfiguration.getMasterHostname(), inboundReplicationConfiguration.getMasterHttpPort(), inboundReplicationConfiguration.getInboundMasterExchangeName(), inboundReplicationConfiguration.getReplicableIds(), inboundReplicationConfiguration.getReplicationCredentials(), inboundReplicationConfiguration.getInboundRabbitMQEndpoint());
    }

    public String getMasterHostname();

    public Integer getMasterHttpPort();

    public String getInboundMasterExchangeName();

    public Iterable<String> getReplicableIds();

    public ReplicationCredentials getReplicationCredentials();

    public RabbitMQEndpoint getInboundRabbitMQEndpoint();

    @Override
    default public Map<ProcessConfigurationVariable, String> getUserData() {
        HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>();
        if (this.getMasterHostname() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATE_MASTER_SERVLET_HOST, this.getMasterHostname());
        }
        if (this.getMasterHttpPort() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATE_MASTER_SERVLET_PORT, "" + this.getMasterHttpPort());
        }
        if (this.getInboundMasterExchangeName() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATE_MASTER_EXCHANGE_NAME, this.getInboundMasterExchangeName());
        }
        if (this.getReplicableIds() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATE_ON_START, String.join((CharSequence)",", this.getReplicableIds()));
        }
        if (this.getReplicationCredentials() != null) {
            result.putAll(this.getReplicationCredentials().getUserData());
        }
        if (this.getInboundRabbitMQEndpoint() != null) {
            result.put(DefaultProcessConfigurationVariables.REPLICATE_MASTER_QUEUE_PORT, Integer.toString(this.getInboundRabbitMQEndpoint().getPort()));
            if (this.getInboundRabbitMQEndpoint().getNodeName() != null) {
                result.put(DefaultProcessConfigurationVariables.REPLICATE_MASTER_QUEUE_HOST, this.getInboundRabbitMQEndpoint().getNodeName());
            }
        }
        return result;
    }

    public static interface Builder {
        public Builder setMasterHostname(String var1);

        public String getMasterHostname();

        public Builder setMasterHttpPort(int var1);

        public int getMasterHttpPort();

        public Builder setInboundMasterExchangeName(String var1);

        public String getInboundMasterExchangeName();

        public Builder setReplicableIds(Iterable<String> var1);

        public Iterable<String> getReplicableIds();

        public Builder setCredentials(ReplicationCredentials var1);

        public ReplicationCredentials getReplicationCredentials();

        public Builder setInboundRabbitMQEndpoint(RabbitMQEndpoint var1);

        public RabbitMQEndpoint getInboundRabbitMQEndpoint();

        public InboundReplicationConfiguration build();
    }
}

