/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.gwt.ui.server.SailingServiceImpl;
import java.util.Optional;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private SailingServiceImpl sailingServiceToStopWhenStopping;
    private static Activator INSTANCE;
    private static final String GOOGLE_MAPS_LOADER_AUTHENTICATION_PARAMS_PROPERTY_NAME = "google.maps.authenticationparams";
    private static final String GOOGLE_MAPS_LOADER_AUTHENTICATION_PARAMS_ENV_VAR_NAME = "GOOGLE_MAPS_AUTHENTICATION_PARAMS";
    private static final String YOUTUBE_V3_API_KEY_PROPERTY_NAME = "youtube.api.key";
    private static final String YOUTUBE_V3_API_KEY_ENV_VAR_NAME = "YOUTUBE_V3_API_KEY";
    private String googleMapsLoaderAuthenticationParams;
    private String youtubeApiKey;

    public Activator() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.googleMapsLoaderAuthenticationParams = Optional.ofNullable(context.getProperty(GOOGLE_MAPS_LOADER_AUTHENTICATION_PARAMS_PROPERTY_NAME)).orElse(System.getenv(GOOGLE_MAPS_LOADER_AUTHENTICATION_PARAMS_ENV_VAR_NAME));
        this.youtubeApiKey = Optional.ofNullable(context.getProperty(YOUTUBE_V3_API_KEY_PROPERTY_NAME)).orElse(System.getenv(YOUTUBE_V3_API_KEY_ENV_VAR_NAME));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.sailingServiceToStopWhenStopping != null) {
            this.sailingServiceToStopWhenStopping.stop();
        }
    }

    public static Activator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Activator();
        }
        return INSTANCE;
    }

    public static BundleContext getDefault() {
        return context;
    }

    public String getGoogleMapsLoaderAuthenticationParams() {
        return this.googleMapsLoaderAuthenticationParams;
    }

    public String getYoutubeApiKey() {
        return this.youtubeApiKey;
    }

    public void setSailingService(SailingServiceImpl sailingServiceImpl) {
        this.sailingServiceToStopWhenStopping = sailingServiceImpl;
    }
}

