/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.datamining.shared.FoilingSegmentsDataMiningSettings;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.polarmining.FoilingSegmentsDataMiningSettingsValidator;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class FoilingSegmentsDataMiningSettingsDialogComponent
implements SettingsDialogComponent<FoilingSegmentsDataMiningSettings> {
    private FoilingSegmentsDataMiningSettings settings;
    private StringMessages stringMessages;
    private DoubleBox minimumFoilingSegmentsDurationInSecondsBox;
    private DoubleBox minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBox;
    private DoubleBox minimumSpeedForFoilingInKnotsBox;
    private DoubleBox maximumSpeedNotFoilingInKnotsBox;
    private DoubleBox minimumRideHeightInMetersBox;

    public FoilingSegmentsDataMiningSettingsDialogComponent(FoilingSegmentsDataMiningSettings settings) {
        this.settings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        Grid grid = new Grid(5, 2);
        grid.setCellPadding(5);
        vp.add((Widget)grid);
        this.setupGrid(grid, dialog);
        return vp;
    }

    private void setupGrid(Grid grid, DataEntryDialog<?> dialog) {
        Label minimumFoilingSegmentsDurationInSecondsLabel = new Label(String.valueOf(this.stringMessages.minimumFoilingSegmentsDurationInSeconds()) + ":");
        minimumFoilingSegmentsDurationInSecondsLabel.setTitle(this.stringMessages.minimumFoilingSegmentsDurationInSecondsTooltip());
        grid.setWidget(0, 0, (Widget)minimumFoilingSegmentsDurationInSecondsLabel);
        this.minimumFoilingSegmentsDurationInSecondsBox = this.settings.getMinimumFoilingSegmentDuration() == null ? dialog.createDoubleBox(6) : dialog.createDoubleBox(Double.valueOf(this.settings.getMinimumFoilingSegmentDuration().asSeconds()), 6);
        grid.setWidget(0, 1, (Widget)this.minimumFoilingSegmentsDurationInSecondsBox);
        Label minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBoxLabel = new Label(String.valueOf(this.stringMessages.minimumDurationBetweenAdjacentFoilingSegmentsInSeconds()) + ":");
        minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBoxLabel.setTitle(this.stringMessages.minimumDurationBetweenAdjacentFoilingSegmentsInSecondsTooltip());
        grid.setWidget(1, 0, (Widget)minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBoxLabel);
        this.minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBox = this.settings.getMinimumDurationBetweenAdjacentFoilingSegments() == null ? dialog.createDoubleBox(6) : dialog.createDoubleBox(Double.valueOf(this.settings.getMinimumFoilingSegmentDuration().asSeconds()), 6);
        grid.setWidget(1, 1, (Widget)this.minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBox);
        Label maximumSpeedNotFoilingInKnotsLabel = new Label(String.valueOf(this.stringMessages.maximumSpeedNotFoilingInKnots()) + ":");
        maximumSpeedNotFoilingInKnotsLabel.setTitle(this.stringMessages.maximumSpeedNotFoilingInKnotsTooltip());
        grid.setWidget(2, 0, (Widget)maximumSpeedNotFoilingInKnotsLabel);
        this.maximumSpeedNotFoilingInKnotsBox = this.settings.getMaximumSpeedNotFoiling() == null ? dialog.createDoubleBox(6) : dialog.createDoubleBox(Double.valueOf(this.settings.getMaximumSpeedNotFoiling().getKnots()), 6);
        grid.setWidget(2, 1, (Widget)this.maximumSpeedNotFoilingInKnotsBox);
        Label minimumSpeedForFoilingInKnotsLabel = new Label(String.valueOf(this.stringMessages.minimumSpeedForFoilingInKnots()) + ":");
        minimumSpeedForFoilingInKnotsLabel.setTitle(this.stringMessages.minimumSpeedForFoilingInKnotsTooltip());
        grid.setWidget(3, 0, (Widget)minimumSpeedForFoilingInKnotsLabel);
        this.minimumSpeedForFoilingInKnotsBox = this.settings.getMinimumSpeedForFoiling() == null ? dialog.createDoubleBox(6) : dialog.createDoubleBox(Double.valueOf(this.settings.getMinimumSpeedForFoiling().getKnots()), 6);
        grid.setWidget(3, 1, (Widget)this.minimumSpeedForFoilingInKnotsBox);
        Label minimumRideHeightInMetersLabel = new Label(String.valueOf(this.stringMessages.minimumRideHeightInMeters()) + ":");
        minimumRideHeightInMetersLabel.setTitle(this.stringMessages.minimumRideHeightInMetersTooltip());
        grid.setWidget(4, 0, (Widget)minimumRideHeightInMetersLabel);
        this.minimumRideHeightInMetersBox = this.settings.getMinimumRideHeight() == null ? dialog.createDoubleBox(6) : dialog.createDoubleBox(Double.valueOf(this.settings.getMinimumRideHeight().getMeters()), 6);
        grid.setWidget(4, 1, (Widget)this.minimumRideHeightInMetersBox);
    }

    public FoilingSegmentsDataMiningSettings getResult() {
        return new FoilingSegmentsDataMiningSettings((Duration)(this.minimumFoilingSegmentsDurationInSecondsBox.getValue() == null ? null : new MillisecondsDurationImpl((long)((Double)this.minimumFoilingSegmentsDurationInSecondsBox.getValue() * 1000.0))), (Duration)(this.minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBox.getValue() == null ? null : new MillisecondsDurationImpl((long)((Double)this.minimumDurationBetweenAdjacentFoilingSegmentsInSecondsBox.getValue() * 1000.0))), (Speed)(this.minimumSpeedForFoilingInKnotsBox.getValue() == null ? null : new KnotSpeedImpl(((Double)this.minimumSpeedForFoilingInKnotsBox.getValue()).doubleValue())), (Speed)(this.maximumSpeedNotFoilingInKnotsBox.getValue() == null ? null : new KnotSpeedImpl(((Double)this.maximumSpeedNotFoilingInKnotsBox.getValue()).doubleValue())), (Distance)(this.minimumRideHeightInMetersBox.getValue() == null ? null : new MeterDistance(((Double)this.minimumRideHeightInMetersBox.getValue()).doubleValue())));
    }

    public FocusWidget getFocusWidget() {
        return this.minimumFoilingSegmentsDurationInSecondsBox;
    }

    public DataEntryDialog.Validator<FoilingSegmentsDataMiningSettings> getValidator() {
        return new FoilingSegmentsDataMiningSettingsValidator(this.stringMessages);
    }
}

