/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining.presentation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.datamining.shared.ManeuverSpeedDetailsAggregation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.presentation.AbstractSailingResultsPresenter;
import com.sap.sailing.gwt.ui.datamining.presentation.ChartFactory;
import com.sap.sailing.gwt.ui.datamining.presentation.ManeuverSpeedDetailsChartConfigurationPanel;
import com.sap.sailing.gwt.ui.datamining.presentation.ManeuverSpeedDetailsResultsPresenter;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.ChartToCsvExporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.XAxis;

public class ManeuverSpeedDetailsResultsPresenter
extends AbstractSailingResultsPresenter<Settings> {
    private final DockLayoutPanel dockLayoutPanel;
    private final Chart polarChart;
    private final SimpleLayoutPanel polarChartWrapperPanel;
    private final Chart lineChart;
    private final Chart dataCountHistogramChart;
    private final DockLayoutPanel rightSideChartsWrapperPanel;
    private final ManeuverSpeedDetailsChartConfigurationPanel chartConfigPanel;
    private Integer minDataCount;
    private Double minValue;
    private Double maxValue;
    private int xAxisMin = -179;
    private int xAxisMax = 180;
    private QueryResultDTO<?> result;

    public ManeuverSpeedDetailsResultsPresenter(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages) {
        super(parent, context, stringMessages);
        this.chartConfigPanel = new ManeuverSpeedDetailsChartConfigurationPanel(() -> this.applyConfiguration(), stringMessages);
        this.addControl((Widget)this.chartConfigPanel);
        ChartToCsvExporter chartToCsvExporter = new ChartToCsvExporter(stringMessages.csvCopiedToClipboard());
        Button exportStatisticsCurveToCsvButton = new Button(stringMessages.exportStatisticsCurveToCsv(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addControl((Widget)exportStatisticsCurveToCsvButton);
        this.polarChart = ChartFactory.createPolarChart();
        ((XAxis)this.polarChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        this.polarChartWrapperPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.polarChartWrapperPanel.add((Widget)this.polarChart);
        this.lineChart = ChartFactory.createLineChartForPolarData((StringMessages)stringMessages);
        ((XAxis)this.lineChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        this.dataCountHistogramChart = ChartFactory.createDataCountHistogramChart((String)(String.valueOf(stringMessages.TWA()) + " (" + stringMessages.degreesShort() + ")"), (StringMessages)stringMessages);
        ((XAxis)this.dataCountHistogramChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        this.rightSideChartsWrapperPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.rightSideChartsWrapperPanel.addNorth((Widget)this.lineChart, 50.0);
        this.rightSideChartsWrapperPanel.addSouth((Widget)this.dataCountHistogramChart, 50.0);
        this.dockLayoutPanel = new DockLayoutPanel(Style.Unit.PCT);
        this.dockLayoutPanel.addWest((Widget)this.polarChartWrapperPanel, 40.0);
        this.dockLayoutPanel.addEast((Widget)this.rightSideChartsWrapperPanel, 60.0);
    }

    private void applyConfiguration() {
        this.minDataCount = this.chartConfigPanel.getMinDataCount();
        this.minValue = this.chartConfigPanel.getMinValue();
        this.maxValue = this.chartConfigPanel.getMaxValue();
        boolean zeroTo360AxisLabeling = this.chartConfigPanel.isZeroTo360AxisLabeling();
        this.xAxisMin = zeroTo360AxisLabeling ? 0 : -179;
        this.xAxisMax = zeroTo360AxisLabeling ? 359 : 180;
        ((XAxis)this.polarChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        ((XAxis)this.lineChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        ((XAxis)this.dataCountHistogramChart.getXAxis().setMin((Number)this.xAxisMin)).setMax((Number)this.xAxisMax);
        if (this.result != null) {
            this.internalShowResults(null, this.result);
        }
    }

    protected Widget getPresentationWidget() {
        return this.dockLayoutPanel;
    }

    protected void internalShowResults(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        this.polarChart.removeAllSeries(false);
        this.lineChart.removeAllSeries(false);
        this.dataCountHistogramChart.removeAllSeries(false);
        this.result = result;
        Map results = result.getResults();
        ArrayList sortedNaturally = new ArrayList(results.keySet());
        Collections.sort(sortedNaturally, new /* Unavailable Anonymous Inner Class!! */);
        for (GroupKey key : sortedNaturally) {
            ManeuverSpeedDetailsAggregation aggregation = (ManeuverSpeedDetailsAggregation)results.get(key);
            double[] valuePerTWA = aggregation.getValuePerTWA();
            int[] countPerTWA = aggregation.getCountPerTWA();
            Series polarSeries = this.polarChart.createSeries();
            Series histogramSeries = this.dataCountHistogramChart.createSeries();
            Series valueSeries = this.lineChart.createSeries();
            int convertedTWA = this.xAxisMin;
            while (convertedTWA <= this.xAxisMax) {
                int i = convertedTWA < 0 ? convertedTWA + 360 : convertedTWA;
                double value = valuePerTWA[i];
                int dataCount = countPerTWA[i];
                if (!(value == 0.0 || this.minValue != null && !(value >= this.minValue) || this.maxValue != null && !(value <= this.maxValue) || this.minDataCount != null && dataCount < this.minDataCount)) {
                    polarSeries.addPoint((Number)convertedTWA, (Number)value, false, false, false);
                    valueSeries.addPoint((Number)convertedTWA, (Number)value, false, false, false);
                } else {
                    polarSeries.addPoint((Number)convertedTWA, null, false, false, false);
                    valueSeries.addPoint((Number)convertedTWA, null, false, false, false);
                }
                histogramSeries.addPoint((Number)convertedTWA, (Number)dataCount, false, false, false);
                ++convertedTWA;
            }
            polarSeries.setName(key.asString());
            valueSeries.setName(key.asString());
            histogramSeries.setName(key.asString());
            this.polarChart.addSeries(polarSeries, false, false);
            histogramSeries.setVisible(false, false);
            valueSeries.setVisible(false, false);
            this.lineChart.addSeries(valueSeries, false, false);
            this.dataCountHistogramChart.addSeries(histogramSeries, false, false);
        }
        this.polarChart.redraw();
        this.lineChart.redraw();
        this.dataCountHistogramChart.redraw();
        5 timer = new /* Unavailable Anonymous Inner Class!! */;
        timer.schedule(200);
    }

    public String getLocalizedShortName() {
        return this.stringMessages.maneuverSpeedDetailsResultsPresenter();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public String getDependentCssClassName() {
        return "maneuverSpeedDetailsResultsPresenter";
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "ManeuverSpeedDetailsResultsPresenter";
    }

    static /* synthetic */ Chart access$0(ManeuverSpeedDetailsResultsPresenter maneuverSpeedDetailsResultsPresenter) {
        return maneuverSpeedDetailsResultsPresenter.lineChart;
    }

    static /* synthetic */ Chart access$1(ManeuverSpeedDetailsResultsPresenter maneuverSpeedDetailsResultsPresenter) {
        return maneuverSpeedDetailsResultsPresenter.polarChart;
    }

    static /* synthetic */ Chart access$2(ManeuverSpeedDetailsResultsPresenter maneuverSpeedDetailsResultsPresenter) {
        return maneuverSpeedDetailsResultsPresenter.dataCountHistogramChart;
    }
}

