/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.google.gwt.user.client.rpc.RemoteService;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.LegIdentifier;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.NotFoundException;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.abstractlog.TimePointSpecificationFoundInLog;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorAndBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.IncrementalOrFullLeaderboardDTO;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.domain.common.dto.PairingListTemplateDTO;
import com.sap.sailing.domain.common.dto.PersonDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.tracking.impl.PreciseCompactGPSFixMovingImpl;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.gwt.ui.shared.BearingWithConfidenceDTO;
import com.sap.sailing.gwt.ui.shared.CompactBoatPositionsDTO;
import com.sap.sailing.gwt.ui.shared.CompactRaceMapDataDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorProviderDTO;
import com.sap.sailing.gwt.ui.shared.CompetitorsRaceDataDTO;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.IgtimiDataAccessWindowWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDeviceWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.ManeuverDTO;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.QRCodeEvent;
import com.sap.sailing.gwt.ui.shared.RaceCourseDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupDTO;
import com.sap.sailing.gwt.ui.shared.RaceLogDTO;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.RaceboardDataDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.RegattaLogDTO;
import com.sap.sailing.gwt.ui.shared.RegattaOverviewEntryDTO;
import com.sap.sailing.gwt.ui.shared.RegattaScoreCorrectionDTO;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sailing.gwt.ui.shared.ScoreCorrectionProviderDTO;
import com.sap.sailing.gwt.ui.shared.SerializationDummy;
import com.sap.sailing.gwt.ui.shared.ServerConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorResultsDTO;
import com.sap.sailing.gwt.ui.shared.SliceRacePreperationDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingArchiveConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingEventRecordDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingReplayRaceDTO;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.TracTracRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.UrlDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.YellowBrickRaceRecordDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.CourseTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPropertiesDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkRoleDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Duration;
import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.gwt.client.replication.RemoteReplicationService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.SecuredDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.shiro.authz.UnauthorizedException;

public interface SailingService
extends RemoteService,
RemoteReplicationService {
    public List<TracTracConfigurationWithSecurityDTO> getPreviousTracTracConfigurations() throws UnauthorizedException, Exception;

    public List<RegattaDTO> getRegattas() throws UnauthorizedException;

    public RegattaDTO getRegattaByName(String var1) throws UnauthorizedException;

    public List<EventDTO> getEvents() throws Exception;

    public Util.Pair<String, List<TracTracRaceRecordDTO>> listTracTracRacesInEvent(String var1, boolean var2, String var3) throws UnauthorizedException, Exception;

    public void replaySwissTimingRace(RegattaIdentifier var1, Iterable<SwissTimingReplayRaceDTO> var2, boolean var3, boolean var4, boolean var5) throws UnauthorizedException;

    public WindInfoForRaceDTO getRawWindFixes(RegattaAndRaceIdentifier var1, Collection<WindSource> var2) throws UnauthorizedException;

    public WindInfoForRaceDTO getAveragedWindInfo(RegattaAndRaceIdentifier var1, Date var2, long var3, int var5, Collection<String> var6, boolean var7, boolean var8) throws NoWindException, UnauthorizedException;

    public WindInfoForRaceDTO getAveragedWindInfo(RegattaAndRaceIdentifier var1, Date var2, Date var3, long var4, Collection<String> var6, boolean var7) throws UnauthorizedException;

    public boolean getPolarResults(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public BearingWithConfidenceDTO getManeuverAngle(BoatClassDTO var1, ManeuverType var2, Speed var3) throws NotEnoughDataHasBeenAddedException, UnauthorizedException;

    public SimulatorResultsDTO getSimulatorResults(LegIdentifier var1) throws UnauthorizedException;

    public RaceboardDataDTO getRaceboardData(String var1, String var2, String var3, String var4, UUID var5, UUID var6) throws UnauthorizedException;

    public Map<CompetitorDTO, BoatDTO> getCompetitorBoats(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public CompactBoatPositionsDTO getBoatPositions(RegattaAndRaceIdentifier var1, Map<String, Date> var2, Map<String, Date> var3, boolean var4, DetailType var5, String var6, String var7, UUID var8) throws NoWindException, UnauthorizedException;

    public RaceTimesInfoDTO getRaceTimesInfo(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public RaceTimesInfoDTO getRaceTimesInfoIncludingTags(RegattaAndRaceIdentifier var1, TimePoint var2) throws UnauthorizedException;

    public List<RaceTimesInfoDTO> getRaceTimesInfos(Collection<RegattaAndRaceIdentifier> var1) throws UnauthorizedException;

    public List<RaceTimesInfoDTO> getRaceTimesInfosIncludingTags(Collection<RegattaAndRaceIdentifier> var1, Map<RegattaAndRaceIdentifier, TimePoint> var2) throws UnauthorizedException;

    public List<String> getLeaderboardNames() throws UnauthorizedException;

    public IncrementalOrFullLeaderboardDTO getLeaderboardByName(String var1, Date var2, Collection<String> var3, boolean var4, String var5, boolean var6) throws UnauthorizedException, Exception;

    public List<CourseAreaDTO> getCourseAreas(String var1);

    public IncrementalOrFullLeaderboardDTO getLeaderboardForRace(RegattaAndRaceIdentifier var1, String var2, Date var3, Collection<String> var4, boolean var5, String var6, boolean var7) throws UnauthorizedException, Exception;

    public List<StrippedLeaderboardDTO> getLeaderboardsWithSecurity() throws UnauthorizedException;

    public Map<String, RegattaAndRaceIdentifier> getRegattaAndRaceNameOfTrackedRaceConnectedToLeaderboardColumn(String var1, String var2) throws UnauthorizedException;

    public List<SwissTimingConfigurationWithSecurityDTO> getPreviousSwissTimingConfigurations() throws UnauthorizedException;

    public SwissTimingEventRecordDTO getRacesOfSwissTimingEvent(String var1) throws UnauthorizedException, Exception;

    public Map<CompetitorDTO, List<GPSFixDTOWithSpeedWindTackAndLegType>> getDouglasPoints(RegattaAndRaceIdentifier var1, Map<CompetitorDTO, TimeRange> var2, double var3) throws NoWindException, UnauthorizedException;

    public Map<CompetitorDTO, List<ManeuverDTO>> getManeuvers(RegattaAndRaceIdentifier var1, Map<CompetitorDTO, TimeRange> var2) throws NoWindException, UnauthorizedException;

    public List<LeaderboardGroupDTO> getLeaderboardGroups(boolean var1) throws UnauthorizedException;

    public LeaderboardGroupDTO getLeaderboardGroupByName(String var1, boolean var2) throws UnauthorizedException;

    public LeaderboardGroupDTO getLeaderboardGroupById(UUID var1) throws UnauthorizedException;

    public LeaderboardGroupDTO getLeaderboardGroupByUuidOrName(UUID var1, String var2);

    public CompetitorsRaceDataDTO getCompetitorsRaceData(RegattaAndRaceIdentifier var1, List<CompetitorDTO> var2, Date var3, Date var4, long var5, DetailType var7, String var8, UUID var9, String var10) throws NoWindException, UnauthorizedException, NotFoundException;

    public Util.Pair<Integer, Integer> resolveImageDimensions(String var1) throws UnauthorizedException, Exception;

    public Iterable<String> getScoreCorrectionProviderNames() throws UnauthorizedException;

    public ScoreCorrectionProviderDTO getScoreCorrectionsOfProvider(String var1) throws UnauthorizedException, Exception;

    public RegattaScoreCorrectionDTO getScoreCorrections(String var1, String var2, String var3, Date var4) throws UnauthorizedException, Exception;

    public Iterable<String> getCompetitorProviderNames() throws UnauthorizedException;

    public CompetitorProviderDTO getCompetitorProviderDTOByName(String var1) throws UnauthorizedException, Exception;

    public Util.Pair<List<CompetitorDescriptor>, String> getCompetitorDescriptorsAndHint(String var1, String var2, String var3, String var4) throws UnauthorizedException, Exception;

    public WindInfoForRaceDTO getWindSourcesInfo(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public ServerConfigurationDTO getServerConfiguration() throws UnauthorizedException;

    public List<RemoteSailingServerReferenceDTO> getRemoteSailingServerReferences() throws UnauthorizedException;

    public List<UrlDTO> getResultImportUrls(String var1) throws UnauthorizedException;

    public String validateResultImportUrl(String var1, UrlDTO var2);

    public List<Util.Pair<String, String>> getUrlResultProviderNamesAndOptionalSampleURL() throws UnauthorizedException;

    public StrippedLeaderboardDTO getLeaderboard(String var1) throws UnauthorizedException;

    public StrippedLeaderboardDTO getLeaderboardWithSecurity(String var1) throws UnauthorizedException;

    public List<SwissTimingReplayRaceDTO> listSwissTiminigReplayRaces(String var1) throws UnauthorizedException;

    public List<Util.Triple<String, List<CompetitorDTO>, List<Double>>> getLeaderboardDataEntriesForAllRaceColumns(String var1, Date var2, DetailType var3) throws UnauthorizedException, Exception;

    public List<String> getOverallLeaderboardNamesContaining(String var1) throws UnauthorizedException;

    public List<SwissTimingArchiveConfigurationWithSecurityDTO> getPreviousSwissTimingArchiveConfigurations() throws UnauthorizedException;

    public List<Util.Pair<String, String>> getLeaderboardsNamesOfMetaLeaderboard(String var1) throws UnauthorizedException;

    public List<RaceGroupDTO> getRegattaStructureForEvent(UUID var1) throws UnauthorizedException;

    public void reloadRaceLog(String var1, RaceColumnDTO var2, FleetDTO var3) throws UnauthorizedException, NotFoundException;

    public RaceLogDTO getRaceLog(String var1, RaceColumnDTO var2, FleetDTO var3) throws UnauthorizedException;

    public RegattaLogDTO getRegattaLog(String var1) throws UnauthorizedException, DoesNotHaveRegattaLogException;

    public Map<String, String> getLeaderboardGroupNamesAndIdsAsStringsFromRemoteServer(String var1, String var2, String var3) throws UnauthorizedException;

    public Iterable<CompetitorDTO> getCompetitors(boolean var1, boolean var2) throws UnauthorizedException;

    public Iterable<CompetitorDTO> getCompetitorsOfLeaderboard(String var1) throws UnauthorizedException;

    public Map<? extends CompetitorDTO, BoatDTO> getCompetitorsAndBoatsOfRace(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Iterable<BoatDTO> getAllBoats() throws UnauthorizedException;

    public Iterable<BoatDTO> getStandaloneBoats() throws UnauthorizedException;

    public BoatDTO getBoatLinkedToCompetitorForRace(String var1, String var2, String var3, String var4) throws UnauthorizedException, NotFoundException;

    public List<DeviceConfigurationWithSecurityDTO> getDeviceConfigurations() throws UnauthorizedException;

    public Util.Triple<Date, Integer, RacingProcedureType> getStartTimeAndProcedure(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Util.Triple<Date, Date, Integer> getFinishingAndFinishTime(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public List<TagDTO> getPrivateTags(String var1, String var2, String var3) throws UnauthorizedException;

    public List<String> getDeserializableDeviceIdentifierTypes() throws UnauthorizedException;

    public Collection<String> getGPSFixImporterTypes() throws UnauthorizedException;

    public Collection<String> getSensorDataImporterTypes() throws UnauthorizedException;

    public Map<Integer, Date> getCompetitorMarkPassings(RegattaAndRaceIdentifier var1, CompetitorDTO var2, boolean var3) throws UnauthorizedException;

    public Map<Integer, Date> getCompetitorRaceLogMarkPassingData(String var1, String var2, String var3, CompetitorDTO var4) throws UnauthorizedException, NotFoundException;

    public Collection<EventDTO> getEventsForLeaderboard(String var1) throws UnauthorizedException;

    public Iterable<RegattaDTO> getManage2SailRegattas(String var1) throws Exception;

    public boolean doesRegattaLogContainCompetitors(String var1) throws UnauthorizedException, DoesNotHaveRegattaLogException, NotFoundException;

    public Util.Pair<RegattaAndRaceIdentifier, SecuredDTO> getRaceIdentifierAndTrackedRaceSecuredDTO(String var1, String var2, String var3);

    public Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog> getTrackingTimes(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Collection<CompetitorAndBoatDTO> getCompetitorRegistrationsForRace(String var1, String var2, String var3) throws UnauthorizedException, DoesNotHaveRegattaLogException, NotFoundException;

    public Collection<CompetitorDTO> getCompetitorRegistrationsInRegattaLog(String var1) throws UnauthorizedException, DoesNotHaveRegattaLogException, NotFoundException;

    public Collection<BoatDTO> getBoatRegistrationsInRegattaLog(String var1) throws UnauthorizedException, DoesNotHaveRegattaLogException, NotFoundException;

    public Collection<BoatDTO> getBoatRegistrationsForLeaderboard(String var1) throws UnauthorizedException, NotFoundException;

    public Boolean areCompetitorRegistrationsEnabledForRace(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Util.Pair<Boolean, String> checkIfMarksAreUsedInOtherRaceLogs(String var1, String var2, String var3, Set<MarkDTO> var4) throws UnauthorizedException, NotFoundException;

    public Collection<CompetitorAndBoatDTO> getCompetitorRegistrationsInRaceLog(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Map<CompetitorDTO, BoatDTO> getCompetitorAndBoatRegistrationsInRaceLog(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Collection<CompetitorDTO> getCompetitorRegistrationsForLeaderboard(String var1) throws UnauthorizedException, NotFoundException;

    public Iterable<MarkDTO> getMarksInTrackedRace(String var1, String var2, String var3) throws UnauthorizedException;

    public boolean canRemoveMarkFix(String var1, String var2, String var3, String var4, GPSFixDTO var5) throws UnauthorizedException;

    public Map<Util.Triple<String, String, String>, Util.Pair<TimePointSpecificationFoundInLog, TimePointSpecificationFoundInLog>> getTrackingTimes(Collection<Util.Triple<String, String, String>> var1) throws UnauthorizedException;

    public SerializationDummy serializationDummy(PersonDTO var1, CountryCode var2, PreciseCompactGPSFixMovingImpl.PreciseCompactPosition var3, TypeRelativeObjectIdentifier var4, SecondsDurationImpl var5, KnotSpeedImpl var6, KilometersPerHourSpeedImpl var7, HasPermissions var8, IgtimiDeviceWithSecurityDTO var9) throws UnauthorizedException;

    public Collection<CompetitorDTO> getEliminatedCompetitors(String var1) throws UnauthorizedException;

    public Iterable<DetailType> determineDetailTypesForCompetitorChart(String var1, UUID var2, RegattaAndRaceIdentifier var3) throws UnauthorizedException;

    public List<ExpeditionDeviceConfiguration> getExpeditionDeviceConfigurations() throws UnauthorizedException;

    public PairingListTemplateDTO calculatePairingListTemplate(int var1, int var2, int var3, int var4, int var5) throws UnauthorizedException, NotFoundException, IllegalArgumentException;

    public PairingListDTO getPairingListFromTemplate(String var1, int var2, Iterable<String> var3, PairingListTemplateDTO var4) throws UnauthorizedException, NotFoundException, PairingListCreationException;

    public PairingListDTO getPairingListFromRaceLogs(String var1) throws UnauthorizedException, NotFoundException;

    public List<String> getRaceDisplayNamesFromLeaderboard(String var1, List<String> var2) throws UnauthorizedException, NotFoundException;

    public Iterable<DetailType> getAvailableDetailTypesForLeaderboard(String var1, RegattaAndRaceIdentifier var2) throws UnauthorizedException;

    public SpotDTO getWindFinderSpot(String var1) throws UnauthorizedException, Exception;

    public SliceRacePreperationDTO prepareForSlicingOfRace(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public Boolean checkIfRaceIsTracking(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public MailInvitationType getMailType() throws UnauthorizedException;

    public String openRegattaRegistrationQrCode(String var1) throws UnauthorizedException;

    public String createRaceBoardLinkQrCode(String var1);

    public ArrayList<IgtimiDeviceWithSecurityDTO> getAllIgtimiDevicesWithSecurity() throws Exception;

    public ArrayList<IgtimiDataAccessWindowWithSecurityDTO> getAllIgtimiDataAccessWindowsWithSecurity() throws Exception;

    public Util.Pair<String, Boolean> getIgtimiConnectionFactoryBaseUrl();

    public BoatDTO getBoat(UUID var1, String var2, String var3);

    public QRCodeEvent getEvent(UUID var1, String var2, String var3);

    public EventDTO getEventById(UUID var1, boolean var2) throws IOException, UnauthorizedException;

    public CompetitorDTO getCompetitor(UUID var1, String var2, String var3);

    public boolean getTrackedRaceIsUsingMarkPassingCalculator(RegattaAndRaceIdentifier var1);

    public ORCPerformanceCurveLegImpl[] getLegGeometry(String var1, String var2, String var3, int[] var4, ORCPerformanceCurveLegTypes[] var5);

    public ORCPerformanceCurveLegImpl[] getLegGeometry(RegattaAndRaceIdentifier var1, int[] var2, ORCPerformanceCurveLegTypes[] var3);

    public Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfo(String var1, String var2, String var3) throws NotFoundException;

    public Map<Integer, ORCPerformanceCurveLegImpl> getORCPerformanceCurveLegInfo(RegattaAndRaceIdentifier var1);

    public Collection<BoatDTO> getBoatRegistrationsForRegatta(RegattaIdentifier var1) throws NotFoundException;

    public Collection<ORCCertificate> getORCCertificates(String var1) throws Exception;

    public Map<String, ORCCertificate> getORCCertificateAssignmentsByBoatIdAsString(RegattaIdentifier var1) throws NotFoundException;

    public Map<String, ORCCertificate> getORCCertificateAssignmentsByBoatIdAsString(String var1, String var2, String var3) throws NotFoundException;

    public ImpliedWindSource getImpliedWindSource(String var1, String var2, String var3) throws NotFoundException;

    public Map<BoatDTO, Set<ORCCertificate>> getSuggestedORCBoatCertificates(ArrayList<BoatDTO> var1) throws Exception;

    public Set<ORCCertificate> searchORCBoatCertificates(CountryCode var1, Integer var2, String var3, String var4, String var5, String var6) throws Exception;

    public List<MarkTemplateDTO> getMarkTemplates();

    public List<MarkPropertiesDTO> getMarkProperties();

    public List<CourseTemplateDTO> getCourseTemplates();

    public List<MarkRoleDTO> getMarkRoles();

    public boolean canSliceRace(RegattaAndRaceIdentifier var1) throws UnauthorizedException;

    public Iterable<MarkDTO> getMarksInRegattaLog(String var1) throws UnauthorizedException, DoesNotHaveRegattaLogException;

    public MarkDTO getMark(UUID var1, String var2, String var3);

    public CoursePositionsDTO getCoursePositions(RegattaAndRaceIdentifier var1, Date var2) throws UnauthorizedException;

    public CompactRaceMapDataDTO getRaceMapData(RegattaAndRaceIdentifier var1, Date var2, Map<String, Date> var3, Map<String, Date> var4, boolean var5, LegIdentifier var6, byte[] var7, Date var8, boolean var9, DetailType var10, String var11, String var12, UUID var13) throws NoWindException, UnauthorizedException;

    public RaceCourseDTO getRaceCourse(RegattaAndRaceIdentifier var1, Date var2) throws UnauthorizedException;

    public List<RegattaOverviewEntryDTO> getRaceStateEntriesForRaceGroup(UUID var1, List<UUID> var2, List<String> var3, boolean var4, boolean var5, Duration var6) throws UnauthorizedException, Exception;

    public RaceCourseDTO getLastCourseDefinitionInRaceLog(String var1, String var2, String var3) throws UnauthorizedException, NotFoundException;

    public Integer getAdminConsoleChangeLogSize();

    public List<YellowBrickConfigurationWithSecurityDTO> getPreviousYellowBrickConfigurations();

    public Util.Pair<String, List<YellowBrickRaceRecordDTO>> listYellowBrickRacesInEvent(YellowBrickConfigurationWithSecurityDTO var1) throws Exception;

    public List<CourseAreaDTO> getCourseAreaForEventOfLeaderboard(String var1);

    public String getGoogleMapsLoaderAuthenticationParams();
}

