/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.WindSourceTypeFormatter;
import com.sap.sse.gwt.client.ErrorReporter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WindSourcesToExcludeSelectorPanel
extends VerticalPanel
implements HasEnabled {
    private final LinkedHashMap<WindSource, CheckBox> checkboxesByWindSource;
    private final StringMessages stringMessages;
    private final SailingServiceWriteAsync service;
    private final ErrorReporter errorReporter;
    private RegattaAndRaceIdentifier raceIdentifier;

    public WindSourcesToExcludeSelectorPanel(SailingServiceWriteAsync service, StringMessages stringMessages, ErrorReporter errorReporter) {
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.service = service;
        this.checkboxesByWindSource = new LinkedHashMap();
        this.add((Widget)new Label(stringMessages.windSourcesUsed()));
    }

    public void update(RegattaAndRaceIdentifier raceIdentifier, Iterable<WindSource> allWindSources, Iterable<WindSource> windSourcesToExclude) {
        this.raceIdentifier = raceIdentifier;
        HashSet windSourcesToRemove = new HashSet(this.checkboxesByWindSource.keySet());
        for (WindSource windSource : allWindSources) {
            windSourcesToRemove.remove(windSource);
            CheckBox checkbox = (CheckBox)this.checkboxesByWindSource.get(windSource);
            if (checkbox == null) {
                checkbox = new CheckBox(WindSourceTypeFormatter.format((WindSource)windSource, (StringMessages)this.stringMessages));
                checkbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.checkboxesByWindSource.put(windSource, checkbox);
                checkbox.setValue(Boolean.valueOf(true));
                this.add((Widget)checkbox);
                continue;
            }
            checkbox.setValue(Boolean.valueOf(true));
        }
        for (WindSource windSourceToExclude : windSourcesToExclude) {
            assert (this.checkboxesByWindSource.containsKey(windSourceToExclude));
            ((CheckBox)this.checkboxesByWindSource.get(windSourceToExclude)).setValue(Boolean.valueOf(false));
        }
        for (WindSource windSourceToRemove : windSourcesToRemove) {
            CheckBox checkboxToRemove = (CheckBox)this.checkboxesByWindSource.remove(windSourceToRemove);
            this.remove((Widget)checkboxToRemove);
        }
    }

    private void onWindSourcesToExcludeChanged(RegattaAndRaceIdentifier raceIdentifier) {
        this.service.setWindSourcesToExclude(raceIdentifier, this.getWindSourcesToExclude(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<WindSource> getWindSourcesToExclude() {
        ArrayList<WindSource> result = new ArrayList<WindSource>();
        for (Map.Entry e : this.checkboxesByWindSource.entrySet()) {
            if (((CheckBox)e.getValue()).getValue().booleanValue()) continue;
            result.add((WindSource)e.getKey());
        }
        return result;
    }

    public boolean isEnabled() {
        return this.checkboxesByWindSource.values().stream().allMatch(CheckBox::isEnabled);
    }

    public void setEnabled(boolean enabled) {
        this.checkboxesByWindSource.values().forEach(checkBox -> checkBox.setEnabled(enabled));
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$0(WindSourcesToExcludeSelectorPanel windSourcesToExcludeSelectorPanel) {
        return windSourcesToExcludeSelectorPanel.raceIdentifier;
    }

    static /* synthetic */ void access$1(WindSourcesToExcludeSelectorPanel windSourcesToExcludeSelectorPanel, RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        windSourcesToExcludeSelectorPanel.onWindSourcesToExcludeChanged(regattaAndRaceIdentifier);
    }

    static /* synthetic */ ErrorReporter access$2(WindSourcesToExcludeSelectorPanel windSourcesToExcludeSelectorPanel) {
        return windSourcesToExcludeSelectorPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$3(WindSourcesToExcludeSelectorPanel windSourcesToExcludeSelectorPanel) {
        return windSourcesToExcludeSelectorPanel.stringMessages;
    }
}

