/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.adminconsole.AddWindFixDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DoubleBox;
import java.util.Date;

public class AddWindFixDialog
extends DataEntryDialog<WindDTO> {
    private final StringMessages stringMessages;
    private final DoubleBox speedInKnotsBox;
    private final DoubleBox fromInDegBox;
    private final DoubleBox latDegBox;
    private final DoubleBox lngDegBox;
    private final DateBox timeBox;

    public AddWindFixDialog(RaceDTO race, CoursePositionsDTO courseDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback<WindDTO> callback) {
        super(stringMessages.actionAddWindData(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new WindDataValidator(stringMessages), callback);
        this.stringMessages = stringMessages;
        this.speedInKnotsBox = this.createDoubleBox(5);
        this.fromInDegBox = this.createDoubleBox(5);
        if (courseDTO != null && courseDTO.waypointPositions != null && courseDTO.waypointPositions.size() > 0 && courseDTO.waypointPositions.get(0) != null) {
            Position positionDTO = (Position)courseDTO.waypointPositions.get(0);
            this.latDegBox = this.createDoubleBox(Double.valueOf(positionDTO.getLatDeg()), 10);
            this.lngDegBox = this.createDoubleBox(Double.valueOf(positionDTO.getLngDeg()), 10);
        } else {
            this.latDegBox = this.createDoubleBox(10);
            this.lngDegBox = this.createDoubleBox(10);
        }
        if (race.trackedRace != null && race.trackedRace.startOfTracking != null) {
            this.timeBox = this.createDateBox(race.trackedRace.startOfTracking.getTime(), 20);
        } else {
            Date now = new Date();
            this.timeBox = this.createDateBox(now.getTime(), 20);
        }
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        Grid grid = new Grid(5, 2);
        mainPanel.add((Widget)grid);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.speedInKnots()) + ":"));
        grid.setWidget(0, 1, (Widget)this.speedInKnotsBox);
        grid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.fromDeg()) + ":"));
        grid.setWidget(1, 1, (Widget)this.fromInDegBox);
        grid.setWidget(2, 0, (Widget)new Label(String.valueOf(this.stringMessages.time()) + ":"));
        grid.setWidget(2, 1, (Widget)this.timeBox);
        grid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.latitude()) + " (" + this.stringMessages.optional() + "):"));
        grid.setWidget(3, 1, (Widget)this.latDegBox);
        grid.setWidget(4, 0, (Widget)new Label(String.valueOf(this.stringMessages.longitude()) + " (" + this.stringMessages.optional() + "):"));
        grid.setWidget(4, 1, (Widget)this.lngDegBox);
        return mainPanel;
    }

    protected WindDTO getResult() {
        WindDTO result = new WindDTO();
        result.trueWindSpeedInKnots = (Double)this.speedInKnotsBox.getValue();
        result.trueWindFromDeg = (Double)this.fromInDegBox.getValue();
        Long l = result.measureTimepoint = this.timeBox.getValue() != null ? Long.valueOf(this.timeBox.getValue().getTime()) : null;
        if (this.latDegBox.getValue() != null && this.lngDegBox.getValue() != null) {
            result.position = new DegreePosition(((Double)this.latDegBox.getValue()).doubleValue(), ((Double)this.lngDegBox.getValue()).doubleValue());
        }
        return result;
    }

    protected Focusable getInitialFocusWidget() {
        return this.speedInKnotsBox;
    }
}

