/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.gwt.ui.adminconsole.DiscardThresholdBoxes;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptor;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractLeaderboardDialog<LD extends LeaderboardDescriptor>
extends DataEntryDialog<LD> {
    protected final StringMessages stringMessages;
    protected TextBox nameTextBox;
    protected TextBox displayNameTextBox;
    protected LD leaderboardDescriptor;
    protected DiscardThresholdBoxes discardThresholdBoxes;

    public AbstractLeaderboardDialog(String title, LD leaderboardDescriptor, StringMessages stringMessages, DataEntryDialog.Validator<LD> validator, DataEntryDialog.DialogCallback<LD> callback) {
        super(title, null, stringMessages.ok(), stringMessages.cancel(), validator, callback);
        this.nameTextBox = this.createTextBox(leaderboardDescriptor.getName());
        this.nameTextBox.setVisibleLength(50);
        this.nameTextBox.ensureDebugId("NameTextBox");
        this.nameTextBox.setEnabled(false);
        this.stringMessages = stringMessages;
        this.leaderboardDescriptor = leaderboardDescriptor;
    }

    protected LD getResult() {
        this.leaderboardDescriptor.setName(this.nameTextBox.getValue().trim());
        this.leaderboardDescriptor.setDisplayName(this.displayNameTextBox.getValue().trim().isEmpty() ? null : this.displayNameTextBox.getValue());
        this.leaderboardDescriptor.setDiscardThresholds(this.discardThresholdBoxes == null ? null : this.discardThresholdBoxes.getDiscardThresholds());
        return (LD)this.leaderboardDescriptor;
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameTextBox;
    }

    protected static ListBox createScoringSchemeListBox(DataEntryDialog<?> dialog, StringMessages stringMessages) {
        ListBox scoringSchemeListBox2 = dialog.createListBox(false);
        ScoringSchemeType[] scoringSchemeTypeArray = ScoringSchemeType.values();
        int n = scoringSchemeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoringSchemeType scoringSchemeType = scoringSchemeTypeArray[n2];
            scoringSchemeListBox2.addItem(ScoringSchemeTypeFormatter.format((ScoringSchemeType)scoringSchemeType, (StringMessages)stringMessages));
            ++n2;
        }
        return scoringSchemeListBox2;
    }

    protected static ScoringSchemeType getSelectedScoringSchemeType(ListBox scoringSchemeListBox, StringMessages stringMessages) {
        ScoringSchemeType result = null;
        int selIndex = scoringSchemeListBox.getSelectedIndex();
        if (selIndex >= 0) {
            String itemText = scoringSchemeListBox.getItemText(selIndex);
            ScoringSchemeType[] scoringSchemeTypeArray = ScoringSchemeType.values();
            int n = scoringSchemeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScoringSchemeType scoringSchemeType = scoringSchemeTypeArray[n2];
                if (ScoringSchemeTypeFormatter.format((ScoringSchemeType)scoringSchemeType, (StringMessages)stringMessages).equals(itemText)) {
                    result = scoringSchemeType;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    protected static <T> ListBox createSortedRegattaLeaderboardsListBox(Collection<StrippedLeaderboardDTO> existingLeaderboards, String preSelectedRegattaName, StringMessages stringMessages, DataEntryDialog<T> dialog) {
        ListBox result = dialog.createListBox(false);
        ArrayList<StrippedLeaderboardDTO> sortedRegattaLeaderboards = new ArrayList<StrippedLeaderboardDTO>();
        for (StrippedLeaderboardDTO leaderboard : existingLeaderboards) {
            sortedRegattaLeaderboards.add(leaderboard);
        }
        Collections.sort(sortedRegattaLeaderboards, (rl1, rl2) -> rl1.getName().compareTo(rl2.getName()));
        result.addItem(stringMessages.pleaseSelectARegatta());
        int i = 1;
        for (StrippedLeaderboardDTO leaderboard : sortedRegattaLeaderboards) {
            if (!leaderboard.type.isRegattaLeaderboard()) continue;
            result.addItem(leaderboard.getName(), leaderboard.getName());
            if (preSelectedRegattaName != null && leaderboard.getName().equals(preSelectedRegattaName)) {
                result.setSelectedIndex(i);
            }
            ++i;
        }
        return result;
    }
}

