/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.statistic;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.common.theme.component.celltable.DesignedCellTableResources;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileNumericStatisticType;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileStatisticDTO;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.SailorProfileDesktopResources;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.statistic.SailorProfileNumericStatisticTypeFormatter;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.statistic.SailorProfileStatisticTable;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sse.common.Duration;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.celltable.SortedCellTable;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserService;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class SailorProfileStatisticTable
extends Composite {
    private static MyBinder uiBinder = (MyBinder)GWT.create(MyBinder.class);
    @UiField(provided=true)
    final SortedCellTable<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>> sailorProfilesTable = new SortedCellTable(0, (CellTable.Resources)DesignedCellTableResources.INSTANCE);
    @UiField
    SpanElement titleUi;
    @UiField
    Image titleIconUi;
    @UiField
    Anchor anchor;
    private final Image titleHeaderRight;
    private final FlagImageResolver flagImageResolver;
    private final SailorProfileNumericStatisticType type;
    private final StringMessages stringMessages;
    private Function<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> navigationTarget;
    private String dataMiningUrl;
    private UserService userService;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> navigatorColumn = new /* Unavailable Anonymous Inner Class!! */;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> actualValueColumn = new /* Unavailable Anonymous Inner Class!! */;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, SimpleCompetitorWithIdDTO> competitorColumn = new /* Unavailable Anonymous Inner Class!! */;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> clubNameColumn = new /* Unavailable Anonymous Inner Class!! */;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> eventNameColumn = new /* Unavailable Anonymous Inner Class!! */;
    private final Column<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> timeColumn = new /* Unavailable Anonymous Inner Class!! */;

    public SailorProfileStatisticTable(FlagImageResolver flagImageResolver, SailorProfileNumericStatisticType type, StringMessages stringMessages, UserService userService) {
        this.userService = userService;
        this.flagImageResolver = flagImageResolver;
        this.type = type;
        this.stringMessages = stringMessages;
        SailorProfileDesktopResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.titleHeaderRight = new Image();
        this.titleHeaderRight.addStyleName(SailorProfileDesktopResources.INSTANCE.css().statisticsTableHeaderRight());
        this.setupTable();
        this.titleUi.setInnerText(SailorProfileNumericStatisticTypeFormatter.getDisplayName((SailorProfileNumericStatisticType)type, (StringMessages)stringMessages));
        this.titleIconUi.setUrl(SailorProfileNumericStatisticTypeFormatter.getIcon((SailorProfileNumericStatisticType)type));
    }

    private void setNavigationTarget(Function<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> navigationTarget, boolean isAverage) {
        if (isAverage) {
            this.setNavigationTarget(navigationTarget);
            this.titleHeaderRight.setVisible(true);
            this.sailorProfilesTable.removeColumn(this.navigatorColumn);
        } else {
            this.navigationTarget = navigationTarget;
            this.titleHeaderRight.setVisible(false);
            this.sailorProfilesTable.addColumn(this.navigatorColumn);
        }
    }

    public void setNavigationTarget(Function<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>, String> navigationTarget) {
        this.titleHeaderRight.setUrl(SharedHomeResources.INSTANCE.arrowDownWhite().getSafeUri());
        this.anchor.getElement().appendChild((Node)this.titleHeaderRight.getElement());
        this.navigationTarget = navigationTarget;
    }

    public void setData(List<Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry>> data) {
        this.sailorProfilesTable.setPageSize(data.size());
        if (data.size() > 0) {
            this.dataMiningUrl = (String)this.navigationTarget.apply(data.get(0));
            this.anchor.setHref(this.dataMiningUrl);
        }
        if (!this.userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.DATA_MINING)) {
            this.anchor.setVisible(false);
        }
        this.sailorProfilesTable.setList(data);
    }

    private void setupTable() {
        boolean isAverage;
        boolean bl = isAverage = this.type.getAggregationType() == SailorProfileNumericStatisticType.StatisticType.AVERAGE;
        if (!isAverage) {
            this.sailorProfilesTable.addColumn(this.eventNameColumn, StringMessages.INSTANCE.eventName());
            this.sailorProfilesTable.addColumn(this.timeColumn, StringMessages.INSTANCE.time());
        }
        this.actualValueColumn.setSortable(true);
        this.sailorProfilesTable.getColumnSortList().push(this.actualValueColumn);
        this.sailorProfilesTable.setInitialSortColumn(this.actualValueColumn);
        this.sailorProfilesTable.setDefaultSortOrder(this.actualValueColumn, true);
        this.sailorProfilesTable.addColumn(this.actualValueColumn, SailorProfileNumericStatisticTypeFormatter.getColumnHeadingName((SailorProfileNumericStatisticType)this.type, (StringMessages)this.stringMessages), (InvertibleComparator)new /* Unavailable Anonymous Inner Class!! */, true);
        this.sailorProfilesTable.addColumn(this.competitorColumn, StringMessages.INSTANCE.competitor());
        this.sailorProfilesTable.addColumn(this.clubNameColumn, StringMessages.INSTANCE.name());
        this.navigatorColumn.setCellStyleNames(DesignedCellTableResources.INSTANCE.cellTableStyle().buttonCell());
        this.navigatorColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        if (!isAverage) {
            this.setNavigationTarget(arg_0 -> this.createRaceboardURL(arg_0), false);
        }
        if (this.userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.DATA_MINING) || !isAverage) {
            this.addButtonStyle(this.actualValueColumn);
            this.addButtonStyle(this.clubNameColumn);
            this.addButtonStyle(this.competitorColumn);
            this.addButtonStyle(this.eventNameColumn);
            this.addButtonStyle(this.navigatorColumn);
            this.addButtonStyle(this.timeColumn);
            this.sailorProfilesTable.addCellPreviewHandler(e -> {
                if ("click".equals(e.getNativeEvent().getType())) {
                    Window.Location.assign((String)((String)this.navigationTarget.apply((Util.Pair)e.getValue())));
                }
            });
        }
    }

    private void addButtonStyle(Column<?, ?> col) {
        col.setCellStyleNames(String.valueOf(col.getCellStyleNames(null, null)) + " " + SailorProfileDesktopResources.INSTANCE.css().clickableColumn());
    }

    private String createRaceboardURL(Util.Pair<SimpleCompetitorWithIdDTO, SailorProfileStatisticDTO.SingleEntry> entry) {
        String result = null;
        if (this.type.getAggregationType() != SailorProfileNumericStatisticType.StatisticType.AVERAGE) {
            RegattaAndRaceIdentifier raceIdentifier = ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getRelatedRaceOrNull();
            RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getLeaderboardNameOrNull(), ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getLeaderboardGroupNameOrNull(), ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getLeaderboardGroupIdOrNull(), ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getEventIdOrNull(), this.type.getPlayerMode().name(), ((SimpleCompetitorWithIdDTO)entry.getA()).getIdAsString());
            RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = new RaceBoardPerspectiveOwnSettings((Duration)new MillisecondsDurationImpl(((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getRelatedTimePointOrNull().asMillis() - ((SailorProfileStatisticDTO.SingleEntry)entry.getB()).getRelatedRaceStartTimePointOrNull().asMillis()));
            HashMap<String, RaceMapSettings> innerSettings = new HashMap<String, RaceMapSettings>();
            innerSettings.put("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)true));
            PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, innerSettings);
            result = EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
        }
        return result;
    }

    static /* synthetic */ Function access$0(SailorProfileStatisticTable sailorProfileStatisticTable) {
        return sailorProfileStatisticTable.navigationTarget;
    }

    static /* synthetic */ SailorProfileNumericStatisticType access$1(SailorProfileStatisticTable sailorProfileStatisticTable) {
        return sailorProfileStatisticTable.type;
    }

    static /* synthetic */ StringMessages access$2(SailorProfileStatisticTable sailorProfileStatisticTable) {
        return sailorProfileStatisticTable.stringMessages;
    }

    static /* synthetic */ FlagImageResolver access$3(SailorProfileStatisticTable sailorProfileStatisticTable) {
        return sailorProfileStatisticTable.flagImageResolver;
    }
}

