/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.racelist;

import com.sap.sailing.gwt.home.desktop.partials.racelist.SortableRaceListColumn;
import java.util.LinkedHashSet;
import java.util.Set;

public class RaceListColumnSet {
    private final Set<SortableRaceListColumn<?, ?>> columns = new LinkedHashSet();
    private final int visibilityAlwaysQuota;
    private final int visibilityMediumQuota;

    public RaceListColumnSet(int visibilityAlwaysQuota, int visibilityMediumQuota) {
        this.visibilityAlwaysQuota = visibilityAlwaysQuota;
        this.visibilityMediumQuota = visibilityMediumQuota;
    }

    public void addColumn(SortableRaceListColumn<?, ?> column) {
        this.columns.add(column);
    }

    public void updateColumnVisibilities() {
        int visibleColumnCount = 0;
        for (SortableRaceListColumn column : this.columns) {
            if (!column.isShowDetails()) continue;
            column.setColumnVisibility(this.getColumnVisibilityByQuota(visibleColumnCount++));
        }
    }

    private SortableRaceListColumn.ColumnVisibility getColumnVisibilityByQuota(int i) {
        return i < this.visibilityAlwaysQuota ? SortableRaceListColumn.ColumnVisibility.ALWAYS : (i < this.visibilityAlwaysQuota + this.visibilityMediumQuota ? SortableRaceListColumn.ColumnVisibility.MEDIUM : SortableRaceListColumn.ColumnVisibility.LARGE);
    }
}

