/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.regatta;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.regatta.SimpleRegattaDTO;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;

public class GetOpenRegattaByRegattaNameAction
implements SailingAction<SimpleRegattaDTO> {
    private String regattaName;
    private String secret;

    private GetOpenRegattaByRegattaNameAction() {
    }

    public GetOpenRegattaByRegattaNameAction(String regattaName, String secret) {
        this.regattaName = regattaName;
        this.secret = secret;
    }

    @GwtIncompatible
    public SimpleRegattaDTO execute(SailingDispatchContext ctx) throws DispatchException {
        Regatta regatta = ctx.getRacingEventService().getRegattaByName(this.regattaName);
        if (regatta == null) {
            throw new DispatchException("Regatta \"" + this.regattaName + "\" not found or not allowed for this action");
        }
        if (!regatta.getCompetitorRegistrationType().isOpen()) {
            throw new DispatchException("Regatta \"" + this.regattaName + "\" not found or not allowed for this action");
        }
        if (!this.secret.equals(regatta.getRegistrationLinkSecret())) {
            throw new DispatchException("Regatta \"" + this.regattaName + "\" not found or not allowed for this action");
        }
        return new SimpleRegattaDTO(regatta.getName());
    }
}

