/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage;

import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import org.apache.commons.math.ArgumentOutsideDomainException;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;

public class DefaultPolarWindAngleBoatSpeedFunction {
    private PolynomialSplineFunction windAngleBoatBearingSpeedFunction;
    private final double[] windAngleXValues = new double[]{0.0, 10.0, 33.0, 44.0, 55.0, 96.0, 130.0, 155.0, 180.0};
    private final double[] boatBearingYValues = new double[]{0.0, 7.0, 11.0, 11.5, 12.5, 14.5, 15.0, 17.0, 11.0};

    public DefaultPolarWindAngleBoatSpeedFunction() {
        SplineInterpolator splineInterpolator = new SplineInterpolator();
        this.windAngleBoatBearingSpeedFunction = splineInterpolator.interpolate(this.windAngleXValues, this.boatBearingYValues);
    }

    public SpeedWithConfidence<Void> getBoatSpeedForWindAngleAndSpeed(Bearing angleToWind, Speed speed) {
        SpeedWithConfidenceImpl result = null;
        try {
            KnotSpeedImpl boatSpeed = new KnotSpeedImpl(this.windAngleBoatBearingSpeedFunction.value(this.convert360AngleTo180RangeAngle(angleToWind.getDegrees())));
            result = new SpeedWithConfidenceImpl((Speed)boatSpeed, 0.5, null);
        }
        catch (ArgumentOutsideDomainException e) {
            e.printStackTrace();
        }
        return result;
    }

    private double convert360AngleTo180RangeAngle(double angle) {
        double result = 0.0;
        if (angle <= 180.0) {
            result = angle;
        }
        if (angle > 180.0) {
            result = 360.0 - angle;
        }
        return result;
    }
}

