/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.actions;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.dashboards.gwt.server.util.actions.startanalysis.StartAnalysisCreationController;
import com.sap.sailing.dashboards.gwt.shared.dispatch.DashboardAction;
import com.sap.sailing.dashboards.gwt.shared.dispatch.DashboardDispatchContext;
import com.sap.sailing.dashboards.gwt.shared.dto.StartAnalysesDTO;
import com.sap.sailing.dashboards.gwt.shared.dto.StartAnalysisDTO;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GetStartAnalysesAction
implements DashboardAction<StartAnalysesDTO> {
    private String leaderboarName;
    private String competitorIdAsString;
    private static final Logger logger = Logger.getLogger(GetStartAnalysesAction.class.getName());

    private GetStartAnalysesAction() {
    }

    public GetStartAnalysesAction(String leaderboardName, String competitorIdAsString) {
        this.leaderboarName = leaderboardName;
        this.competitorIdAsString = competitorIdAsString;
    }

    @GwtIncompatible
    public StartAnalysesDTO execute(DashboardDispatchContext dashboardDispatchContext) throws DispatchException {
        StartAnalysesDTO result = new StartAnalysesDTO();
        ArrayList<StartAnalysisDTO> startanalyses = new ArrayList<StartAnalysisDTO>();
        if (this.leaderboarName != null) {
            try {
                Leaderboard leaderboard;
                DynamicCompetitor competitor = null;
                if (this.competitorIdAsString != null) {
                    competitor = dashboardDispatchContext.getRacingEventService().getBaseDomainFactory().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(this.competitorIdAsString);
                }
                if ((leaderboard = dashboardDispatchContext.getRacingEventService().getLeaderboardByName(this.leaderboarName)) != null) {
                    for (RaceColumn column : leaderboard.getRaceColumns()) {
                        for (Fleet fleet : column.getFleets()) {
                            StartAnalysisDTO startAnalysisDTO;
                            TrackedRace race = column.getTrackedRace(fleet);
                            if (race == null || (startAnalysisDTO = StartAnalysisCreationController.checkStartAnalysisForCompetitorInTrackedRace((DashboardDispatchContext)dashboardDispatchContext, (Competitor)competitor, (TrackedRace)race)) == null) continue;
                            startanalyses.add(startAnalysisDTO);
                        }
                    }
                }
            }
            catch (NullPointerException e) {
                logger.log(Level.INFO, "", e);
            }
        }
        result.setStartAnalyses(startanalyses);
        return result;
    }
}

