/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum ConnectOption {
    ConnectionID(1),
    CompleteArrayExecution(2),
    ClientLocale(3),
    SupportsLargeBulkOperations(4),
    DistributionEnabled(5),
    PrimaryConnectionID(6),
    PrimaryConnectionHost(7),
    PrimaryConnectionPort(8),
    CompleteDatatypeSupport(9),
    LargeNumberOfParametersSupport(10),
    SystemID(11),
    DataFormatVersion(12),
    AbapVarcharMode(13),
    SelectForUpdateSupported(14),
    ClientDistributionMode(15),
    EngineDataFormatVersion(16),
    DistributionProtocolVersion(17),
    SplitBatchCommands(18),
    UseTransactionFlagsOnly(19),
    RowSlotImageParameter(20),
    IgnoreUnknownParts(21),
    TableOutputParameterMetadataSupport(22),
    DataFormatVersion2(23),
    ItabParameter(24),
    DescribeTableOutputParameter(25),
    ColumnarResultSet(26),
    ScrollableResultSet(27),
    ClientInfoNullValueSupported(28),
    AssociatedConnectionID(29),
    NonTransactionalPrepare(30),
    FdaEnabled(31),
    OSUser(32),
    RowSlotImageResultSet(33),
    Endianness(34),
    UpdateTopologyAnwhere(35),
    EnableArrayType(36),
    ImplicitLobStreaming(37),
    CachedViewProperty(38),
    XOpenXAProtocolSupported(39),
    MasterCommitRedirectionSupported(40),
    ActiveActiveProtocolVersion(41),
    ActiveActiveConnectionOriginSite(42),
    QueryTimeoutSupported(43),
    FullVersionString(44),
    DatabaseName(45),
    BuildPlatform(46),
    ImplicitXASessionSupported(47),
    ClientSideColumnEncryptionVersion(48),
    CompressionLevelAndFlags(49),
    ClientSideReExecutionSupported(50),
    ClientReconnectWaitTimeout(51),
    OriginalAnchorConnectionID(52),
    FlagSet1(53),
    TopologyNetworkGroup(54),
    IPAddress(55),
    LRRPingTime(56),
    Unknown(-1);

    private static final ConnectOption[] VALUES;

    public static ConnectOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return ConnectOption.decode(value).name() + '(' + value + ')';
    }

    private ConnectOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = ConnectOption.values();
    }
}

