/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingreplayadapter.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingreplayadapter.SwissTimingReplayService;
import com.sap.sailing.domain.swisstimingreplayadapter.impl.SwissTimingReplayToDomainAdapter;
import com.sap.sailing.domain.tracking.AbstractRaceTrackerImpl;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParameters;
import com.sap.sse.common.Util;

public class SwissTimingReplayConnectivityParameters
extends AbstractRaceTrackingConnectivityParameters {
    private static final long serialVersionUID = -1380661620949638776L;
    public static final String TYPE = "SWISS_TIMING_REPLAY";
    private final boolean useInternalMarkPassingAlgorithm;
    private final transient DomainFactory domainFactory;
    private final String boatClassName;
    private final transient RaceLogStore raceLogStore;
    private final transient RegattaLogStore regattaLogStore;
    private final String raceName;
    private final String raceID;
    private final String link;
    private final String swissTimingUrl;
    private final transient SwissTimingReplayService replayService;

    public SwissTimingReplayConnectivityParameters(String link, String swissTimingUrl, String raceName, String raceID, String boatClassName, boolean useInternalMarkPassingAlgorithm, DomainFactory domainFactory, SwissTimingReplayService replayService, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore) {
        super(false, false);
        this.link = link;
        this.swissTimingUrl = swissTimingUrl;
        this.raceName = raceName;
        this.raceID = raceID;
        this.boatClassName = boatClassName;
        this.useInternalMarkPassingAlgorithm = useInternalMarkPassingAlgorithm;
        this.domainFactory = domainFactory;
        this.replayService = replayService;
        this.raceLogStore = raceLogStore;
        this.regattaLogStore = regattaLogStore;
    }

    public RaceTracker createRaceTracker(TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) throws Exception {
        SwissTimingReplayToDomainAdapter listener = new SwissTimingReplayToDomainAdapter(null, this.raceName, this.raceID, this.domainFactory.getBaseDomainFactory().getOrCreateBoatClass(this.boatClassName), this.domainFactory, trackedRegattaRegistry, this.useInternalMarkPassingAlgorithm, raceLogResolver, this.raceLogStore, this.regattaLogStore, l -> new SwissTimingReplayRaceTracker(windStore, l, this), raceTrackingHandler, markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        this.replayService.loadRaceData(this.link, listener);
        return listener.getTracker();
    }

    public RaceTracker createRaceTracker(Regatta regatta, TrackedRegattaRegistry trackedRegattaRegistry, WindStore windStore, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) throws Exception {
        SwissTimingReplayToDomainAdapter listener = new SwissTimingReplayToDomainAdapter(regatta, this.raceName, this.raceID, this.domainFactory.getBaseDomainFactory().getOrCreateBoatClass(this.boatClassName), this.domainFactory, trackedRegattaRegistry, this.useInternalMarkPassingAlgorithm, raceLogResolver, this.raceLogStore, this.regattaLogStore, l -> new SwissTimingReplayRaceTracker(windStore, l, this), raceTrackingHandler, markPassingRaceFingerprintRegistry, maneuverRaceFingerprintRegistry);
        this.replayService.loadRaceData(this.link, listener);
        return listener.getTracker();
    }

    public Object getTrackerID() {
        return new Util.Pair((Object)this.link, (Object)this.raceID);
    }

    public long getDelayToLiveInMillis() {
        return 0L;
    }

    public String getTypeIdentifier() {
        return TYPE;
    }

    public boolean isUseInternalMarkPassingAlgorithm() {
        return this.useInternalMarkPassingAlgorithm;
    }

    public String getBoatClassName() {
        return this.boatClassName;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public String getRaceID() {
        return this.raceID;
    }

    public String getLink() {
        return this.link;
    }

    public String getSwissTimingUrl() {
        return this.swissTimingUrl;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " for " + this.raceName + "/" + this.raceID + ", link: " + this.link + ", boatClassName: " + this.boatClassName;
    }

    class SwissTimingReplayRaceTracker
    extends AbstractRaceTrackerImpl<SwissTimingReplayConnectivityParameters> {
        private final WindStore windStore;
        private SwissTimingReplayToDomainAdapter listener;

        public SwissTimingReplayRaceTracker(WindStore windStore, SwissTimingReplayToDomainAdapter listener, SwissTimingReplayConnectivityParameters connectivityParams) {
            super((RaceTrackingConnectivityParameters)connectivityParams);
            this.windStore = windStore;
            this.listener = listener;
        }

        public Regatta getRegatta() {
            return this.listener.getRegatta();
        }

        public void notifyRaceCreationListeners() {
            super.notifyRaceCreationListeners();
        }

        public RaceDefinition getRace() {
            try {
                RaceDefinition race = this.listener.getRaceDefinition(SwissTimingReplayConnectivityParameters.this.raceID, 1L);
                return race;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public DynamicTrackedRegatta getTrackedRegatta() {
            return this.listener.getTrackedRegatta();
        }

        public RaceHandle getRaceHandle() {
            return new RaceHandle(){

                public Regatta getRegatta() {
                    return SwissTimingReplayRaceTracker.this.listener.getRegatta();
                }

                public RaceDefinition getRace() {
                    try {
                        return SwissTimingReplayRaceTracker.this.listener.getRaceDefinition(SwissTimingReplayConnectivityParameters.this.raceID);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }

                public RaceDefinition getRace(long timeoutInMilliseconds) {
                    try {
                        return SwissTimingReplayRaceTracker.this.listener.getRaceDefinition(SwissTimingReplayConnectivityParameters.this.raceID, timeoutInMilliseconds);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }

                public DynamicTrackedRegatta getTrackedRegatta() {
                    return SwissTimingReplayRaceTracker.this.getTrackedRegatta();
                }

                public RaceTracker getRaceTracker() {
                    return SwissTimingReplayRaceTracker.this;
                }
            };
        }

        public WindStore getWindStore() {
            return this.windStore;
        }

        public Object getID() {
            return SwissTimingReplayConnectivityParameters.this.getTrackerID();
        }
    }
}

