/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.swisstimingadapter.MessageType;
import com.sap.sailing.domain.swisstimingadapter.SailMasterMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SailMasterMessageImpl
implements SailMasterMessage {
    private static Pattern leadingSequenceNumber = Pattern.compile("^([0-9][0-9]*)\\|(.*)$");
    private final String message;
    private final Long sequenceNumber;
    private String[] sections;

    public SailMasterMessageImpl(String message) {
        Matcher m = leadingSequenceNumber.matcher(message);
        if (m.matches()) {
            this.sequenceNumber = Long.valueOf(m.group(1));
            this.message = m.group(2);
        } else {
            this.sequenceNumber = null;
            this.message = message;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public synchronized String[] getSections() {
        if (this.sections == null) {
            this.sections = this.getMessage().split("\\|");
        }
        return this.sections;
    }

    public String toString() {
        return String.valueOf(this.getSequenceNumber() == null ? "" : this.getSequenceNumber() + ": ") + this.getMessage();
    }

    @Override
    public MessageType getType() {
        String typeAsStringWithOptionalSuffix = this.getSections()[0];
        String typeAsString = this.isEvent() ? typeAsStringWithOptionalSuffix : typeAsStringWithOptionalSuffix.substring(0, typeAsStringWithOptionalSuffix.length() - 1);
        try {
            return MessageType.valueOf(typeAsString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean isRequest() {
        return this.getSections()[0].charAt(this.getSections()[0].length() - 1) == '?';
    }

    @Override
    public boolean isResponse() {
        return this.getSections()[0].charAt(this.getSections()[0].length() - 1) == '!';
    }

    @Override
    public boolean isEvent() {
        return !this.isRequest() && !this.isResponse();
    }

    @Override
    public String getRaceID() {
        String result = this.getType().isRaceSpecific() ? this.getSections()[1] : null;
        return result;
    }
}

