/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.swisstimingadapter.Competitor;
import com.sap.sailing.domain.swisstimingadapter.Course;
import com.sap.sailing.domain.swisstimingadapter.CrewMember;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.Fix;
import com.sap.sailing.domain.swisstimingadapter.Mark;
import com.sap.sailing.domain.swisstimingadapter.Race;
import com.sap.sailing.domain.swisstimingadapter.RaceType;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.impl.CompetitorWithoutID;
import com.sap.sailing.domain.swisstimingadapter.impl.RaceTypeImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.impl.CourseDesignUpdateHandler;
import com.sap.sailing.domain.tracking.impl.FinishTimeUpdateHandler;
import com.sap.sailing.domain.tracking.impl.RaceAbortedHandler;
import com.sap.sailing.domain.tracking.impl.StartTimeUpdateHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.impl.UUIDHelper;
import difflib.PatchFailedException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public class DomainFactoryImpl
implements DomainFactory {
    private static final Logger logger = Logger.getLogger(DomainFactoryImpl.class.getName());
    private final Map<String, Regatta> raceIDToRegattaCache;
    private final Map<Iterable<Serializable>, ControlPoint> controlPointCache;
    private final Map<String, RaceType> raceTypeByID;
    private final RaceType unknownRaceType;
    private final com.sap.sailing.domain.base.DomainFactory baseDomainFactory;

    public DomainFactoryImpl(com.sap.sailing.domain.base.DomainFactory baseDomainFactory) {
        this.baseDomainFactory = baseDomainFactory;
        this.raceIDToRegattaCache = new HashMap<String, Regatta>();
        this.controlPointCache = new HashMap<Iterable<Serializable>, ControlPoint>();
        this.raceTypeByID = new HashMap<String, RaceType>();
        RaceType.OlympicRaceCode[] olympicRaceCodeArray = RaceType.OlympicRaceCode.values();
        int n = olympicRaceCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RaceType.OlympicRaceCode olympicRaceCode = olympicRaceCodeArray[n2];
            this.raceTypeByID.put(olympicRaceCode.swissTimingCode, new RaceTypeImpl(olympicRaceCode, baseDomainFactory.getOrCreateBoatClass(olympicRaceCode.boatClassName, olympicRaceCode.typicallyStartsUpwind)));
            ++n2;
        }
        this.unknownRaceType = new RaceTypeImpl(RaceType.OlympicRaceCode.UNKNOWN, baseDomainFactory.getOrCreateBoatClass("Unknown", RaceType.OlympicRaceCode.UNKNOWN.typicallyStartsUpwind));
    }

    @Override
    public com.sap.sailing.domain.base.DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    @Override
    public Regatta getOrCreateDefaultRegatta(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String raceID, BoatClass boatClass, TrackedRegattaRegistry trackedRegattaRegistry) {
        Regatta result = trackedRegattaRegistry.getRememberedRegattaForRace((Serializable)((Object)raceID));
        if (result == null) {
            result = this.raceIDToRegattaCache.get(raceID);
        }
        if (result == null) {
            BoatClass regattaBoatClass = boatClass != null ? boatClass : this.getRaceTypeFromRaceID(raceID).getBoatClass();
            Calendar calendar = Calendar.getInstance();
            result = new RegattaImpl(raceLogStore, regattaLogStore, RegattaImpl.getDefaultName((String)("ST Regatta " + calendar.get(1) + " for race " + raceID), (String)regattaBoatClass.getName()), regattaBoatClass, true, CompetitorRegistrationType.CLOSED, null, null, trackedRegattaRegistry, this.getBaseDomainFactory().createScoringScheme(ScoringSchemeType.LOW_POINT), (Serializable)((Object)raceID), null, UUID.randomUUID().toString());
            logger.info("Created regatta " + result.getName() + " (" + result.hashCode() + ")");
            this.raceIDToRegattaCache.put(raceID, result);
        }
        return result;
    }

    @Override
    public Util.Pair<com.sap.sailing.domain.base.Competitor, Boat> createCompetitorWithID(Competitor competitor, BoatClass boatClass, RaceTrackingHandler raceTrackHandler) {
        Serializable competitorId;
        CompetitorAndBoatStore competitorAndBoatStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        CompetitorWithBoat domainCompetitor = competitorAndBoatStore.getExistingCompetitorWithBoatById(competitorId = UUIDHelper.tryUuidConversion((Serializable)((Object)competitor.getIdAsString())));
        if (domainCompetitor == null || competitorAndBoatStore.isCompetitorToUpdateDuringGetOrCreate((com.sap.sailing.domain.base.Competitor)domainCompetitor)) {
            ArrayList<PersonImpl> teamMembers = new ArrayList<PersonImpl>();
            if (competitor.getCrew().isEmpty()) {
                PersonImpl dummyPerson = new PersonImpl(competitor.getName().trim(), this.getOrCreateNationality(competitor.getThreeLetterIOCCode()), null, "Team");
                teamMembers.add(dummyPerson);
            } else {
                for (CrewMember crewMember : competitor.getCrew()) {
                    PersonImpl person = new PersonImpl(crewMember.getName().trim(), this.getOrCreateNationality(crewMember.getNationality()), null, crewMember.getPosition());
                    teamMembers.add(person);
                }
            }
            TeamImpl team = new TeamImpl(competitor.getName(), teamMembers, null);
            DynamicBoat domainBoat = raceTrackHandler.getOrCreateBoat(competitorAndBoatStore, competitorId, null, boatClass, competitor.getBoatID(), null);
            domainCompetitor = raceTrackHandler.getOrCreateCompetitorWithBoat(competitorAndBoatStore, competitorId, competitor.getName(), null, null, null, null, (DynamicTeam)team, null, null, null, domainBoat);
        }
        return new Util.Pair((Object)domainCompetitor, (Object)domainCompetitor.getBoat());
    }

    @Override
    public Util.Pair<com.sap.sailing.domain.base.Competitor, Boat> createCompetitorWithoutID(Competitor competitor, String raceId, BoatClass boatClass, RaceTrackingHandler raceTrackHandler) {
        CompetitorAndBoatStore competitorAndBoatStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        ArrayList<PersonImpl> teamMembers = new ArrayList<PersonImpl>();
        String[] stringArray = competitor.getName().split("[-+&]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String teamMemberName = stringArray[n2];
            teamMembers.add(new PersonImpl(teamMemberName.trim(), this.getOrCreateNationality(competitor.getThreeLetterIOCCode()), null, teamMemberName.trim()));
            ++n2;
        }
        TeamImpl team = new TeamImpl(competitor.getName(), teamMembers, null);
        String competitorID = this.getCompetitorID(competitor.getBoatID(), competitor.getName(), raceId, boatClass);
        BoatImpl domainBoat = new BoatImpl((Serializable)UUID.randomUUID(), null, boatClass, competitor.getBoatID(), null);
        DynamicCompetitorWithBoat domainCompetitor = raceTrackHandler.getOrCreateCompetitorWithBoat(competitorAndBoatStore, (Serializable)((Object)competitorID), competitor.getName(), null, null, null, null, (DynamicTeam)team, null, null, null, (DynamicBoat)domainBoat);
        return new Util.Pair((Object)domainCompetitor, (Object)domainCompetitor.getBoat());
    }

    @Override
    public Util.Pair<com.sap.sailing.domain.base.Competitor, Boat> createCompetitorWithoutID(String boatID, String threeLetterIOCCode, String name, String raceId, BoatClass boatClass, RaceTrackingHandler raceTrackingHandler) {
        return this.createCompetitorWithoutID(new CompetitorWithoutID(boatID, threeLetterIOCCode, name), raceId, boatClass, raceTrackingHandler);
    }

    private String getCompetitorID(String boatID, String name, String raceId, BoatClass boatClass) {
        String result = null;
        if (boatClass != null) {
            result = this.getCompetitorID(boatID, name, boatClass);
        } else {
            RaceType raceType = this.getRaceTypeFromRaceID(raceId);
            if (raceType != null) {
                result = this.getCompetitorID(boatID, name, raceType);
            }
        }
        return result;
    }

    private String getCompetitorID(String boatID, String name, BoatClass boatClass) {
        return String.valueOf(this.getCompetitorID(boatID, boatClass)) + "/" + name;
    }

    private String getCompetitorID(String boatID, String name, RaceType raceType) {
        return String.valueOf(this.getCompetitorID(boatID, raceType)) + "/" + name;
    }

    @Override
    public String getCompetitorID(String boatID, RaceType raceType) {
        return String.valueOf(boatID) + "/" + (Object)((Object)raceType.getRaceCode());
    }

    @Override
    public String getCompetitorID(String boatID, BoatClass boatClass) {
        return String.valueOf(boatID) + "/" + boatClass.getName();
    }

    @Override
    public RaceDefinition createRaceDefinition(Regatta regatta, String swissTimingRaceID, Map<com.sap.sailing.domain.base.Competitor, Boat> competitorsAndBoats, List<ControlPoint> courseDefinition, String raceName, String raceIdForRaceDefinition, RaceTrackingHandler raceTrackingHandler) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        for (ControlPoint controlPoint : courseDefinition) {
            Waypoint waypoint = this.baseDomainFactory.createWaypoint(controlPoint, PassingInstruction.None);
            waypoints.add(waypoint);
        }
        CourseImpl domainCourse = new CourseImpl("Course", waypoints);
        BoatClass boatClass = this.getRaceTypeFromRaceID(swissTimingRaceID).getBoatClass();
        logger.info("Creating RaceDefinitionImpl for race " + swissTimingRaceID);
        RaceDefinition result = raceTrackingHandler.createRaceDefinition(regatta, raceName, (com.sap.sailing.domain.base.Course)domainCourse, boatClass, competitorsAndBoats, (Serializable)((Object)raceIdForRaceDefinition));
        regatta.addRace(result);
        return result;
    }

    @Override
    public RaceDefinition createRaceDefinition(Regatta regatta, Race race, StartList startList, Course course, RaceTrackingHandler raceTrackingHandler) {
        com.sap.sailing.domain.base.Course domainCourse = this.createCourse(race.getDescription(), course);
        Map<com.sap.sailing.domain.base.Competitor, Boat> competitorsAndBoats = this.createCompetitorsAndBoats(startList, race.getRaceID(), race.getBoatClass(), raceTrackingHandler);
        logger.info("Creating RaceDefinitionImpl for race " + race.getRaceID());
        BoatClass boatClass = race.getBoatClass() != null ? race.getBoatClass() : this.getRaceTypeFromRaceID(race.getRaceID()).getBoatClass();
        RaceDefinition result = raceTrackingHandler.createRaceDefinition(regatta, race.getRaceName(), domainCourse, boatClass, competitorsAndBoats, (Serializable)((Object)race.getRaceID()));
        regatta.addRace(result);
        return result;
    }

    @Override
    public RaceType getRaceTypeFromRaceID(String raceID) {
        String[] optionalEventIDAndMandatoryRaceID;
        String swissTimingRaceCode;
        RaceType raceType;
        RaceType result = raceID != null && raceID.length() >= 6 ? ((raceType = this.raceTypeByID.get(swissTimingRaceCode = (optionalEventIDAndMandatoryRaceID = raceID.split("_"))[optionalEventIDAndMandatoryRaceID.length - 1].substring(0, 6).toUpperCase())) == null ? this.unknownRaceType : raceType) : this.unknownRaceType;
        return result;
    }

    @Override
    public Map<com.sap.sailing.domain.base.Competitor, Boat> createCompetitorsAndBoats(StartList startList, String raceId, BoatClass boatClass, RaceTrackingHandler raceTrackHandler) {
        LinkedHashMap<com.sap.sailing.domain.base.Competitor, Boat> result = new LinkedHashMap<com.sap.sailing.domain.base.Competitor, Boat>();
        for (Competitor swissTimingCompetitor : startList.getCompetitors()) {
            Util.Pair<com.sap.sailing.domain.base.Competitor, Boat> domainCompetitorAndBoat = swissTimingCompetitor.getIdAsString() != null ? this.createCompetitorWithID(swissTimingCompetitor, boatClass, raceTrackHandler) : this.createCompetitorWithoutID(swissTimingCompetitor, raceId, boatClass, raceTrackHandler);
            result.put((com.sap.sailing.domain.base.Competitor)domainCompetitorAndBoat.getA(), (Boat)domainCompetitorAndBoat.getB());
        }
        return result;
    }

    private com.sap.sailing.domain.base.Course createCourse(String courseName, Course course) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        for (Mark mark : course.getMarks()) {
            ControlPoint controlPoint = this.getOrCreateControlPoint(mark.getDescription(), mark.getDeviceIds(), this.getMarkType(mark.getMarkType()), mark.getDescription());
            if (controlPoint == null) continue;
            Waypoint waypoint = this.baseDomainFactory.createWaypoint(controlPoint, PassingInstruction.None);
            waypoints.add(waypoint);
        }
        CourseImpl result = new CourseImpl(courseName, waypoints);
        return result;
    }

    private MarkType getMarkType(Mark.MarkType markType) {
        MarkType result = markType == null ? null : MarkType.BUOY;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControlPoint getOrCreateControlPoint(String description, Iterable<Serializable> deviceIds, MarkType markType, String shortNameOfPotentialGate) {
        ControlPoint result;
        Map<Iterable<Serializable>, ControlPoint> map = this.controlPointCache;
        synchronized (map) {
            result = this.controlPointCache.get(deviceIds);
            if (result == null) {
                switch (Util.size(deviceIds)) {
                    case 1: {
                        result = this.getOrCreateMark(description, deviceIds.iterator().next(), markType);
                        break;
                    }
                    case 2: {
                        Iterator<Serializable> markNameIter = deviceIds.iterator();
                        Serializable idLeft = markNameIter.next();
                        Serializable idRight = markNameIter.next();
                        result = this.baseDomainFactory.createControlPointWithTwoMarks(this.getOrCreateMark(idLeft, description), this.getOrCreateMark(idRight, description), description, shortNameOfPotentialGate);
                        break;
                    }
                    default: {
                        logger.info("Ignoring mark " + description + " because it doesn't have any devices assigned");
                    }
                }
                if (result != null) {
                    this.controlPointCache.put(deviceIds, result);
                }
            }
        }
        return result;
    }

    private ControlPoint getOrCreateMark(String description, Serializable id, MarkType markType) {
        return this.baseDomainFactory.getOrCreateMark(id, description, markType);
    }

    @Override
    public com.sap.sailing.domain.base.Mark getOrCreateMark(Serializable trackerId, String description) {
        return this.baseDomainFactory.getOrCreateMark(trackerId, description, description);
    }

    @Override
    public GPSFixMoving createGPSFix(TimePoint timePointOfTransmission, Fix fix) {
        GPSFixMovingImpl result = new GPSFixMovingImpl(fix.getPosition(), (TimePoint)new MillisecondsTimePoint(timePointOfTransmission.asMillis() + fix.getAgeOfDataInMilliseconds()), fix.getSpeed(), null);
        return result;
    }

    @Override
    public void updateCourseWaypoints(com.sap.sailing.domain.base.Course courseToUpdate, Iterable<Mark> marks) throws PatchFailedException {
        ArrayList<Util.Pair> newDomainControlPoints = new ArrayList<Util.Pair>();
        for (Mark mark : marks) {
            ControlPoint domainControlPoint = this.getOrCreateControlPoint(mark.getDescription(), mark.getDeviceIds(), this.getMarkType(mark.getMarkType()), mark.getDescription());
            if (domainControlPoint == null) continue;
            newDomainControlPoints.add(new Util.Pair((Object)domainControlPoint, (Object)PassingInstruction.None));
        }
        courseToUpdate.update(newDomainControlPoints, courseToUpdate.getAssociatedRoles(), courseToUpdate.getOriginatingCourseTemplateIdOrNull(), this.baseDomainFactory);
    }

    @Override
    public MarkPassing createMarkPassing(TimePoint timePoint, Waypoint waypoint, com.sap.sailing.domain.base.Competitor competitor) {
        return this.baseDomainFactory.createMarkPassing(timePoint, waypoint, competitor);
    }

    @Override
    public Nationality getOrCreateNationality(String threeLetterIOCCode) {
        return this.baseDomainFactory.getOrCreateNationality(threeLetterIOCCode);
    }

    @Override
    public RaceTrackingConnectivityParameters createTrackingConnectivityParameters(String hostname, int port, String raceID, String raceName, String raceDescription, BoatClass boatClass, StartList startList, long delayToLiveInMillis, SwissTimingFactory swissTimingFactory, DomainFactory domainFactory, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, boolean useInternalMarkPassingAlgorithm, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, String updateURL, String apiToken, String eventName, String manage2SailEventUrl) {
        return new SwissTimingTrackingConnectivityParameters(hostname, port, raceID, raceName, raceDescription, boatClass, startList, delayToLiveInMillis, swissTimingFactory, domainFactory, raceLogStore, regattaLogStore, useInternalMarkPassingAlgorithm, trackWind, correctWindDirectionByMagneticDeclination, updateURL, apiToken, eventName, manage2SailEventUrl);
    }

    @Override
    public void addUpdateHandlers(String updateURL, String apiToken, Serializable eventId, RaceDefinition raceDefinition, DynamicTrackedRace trackedRace) throws URISyntaxException {
        URI updateURI = updateURL == null ? null : new URI(updateURL);
        CourseDesignUpdateHandler courseDesignHandler = new CourseDesignUpdateHandler(updateURI, apiToken, eventId, raceDefinition.getId());
        StartTimeUpdateHandler startTimeHandler = new StartTimeUpdateHandler(updateURI, apiToken, eventId, raceDefinition.getId(), trackedRace.getTrackedRegatta().getRegatta());
        RaceAbortedHandler raceAbortedHandler = new RaceAbortedHandler(updateURI, apiToken, eventId, raceDefinition.getId());
        FinishTimeUpdateHandler finishTimeUpdateHandler = new FinishTimeUpdateHandler(updateURI, apiToken, eventId, raceDefinition.getId(), trackedRace.getTrackedRegatta().getRegatta());
        this.baseDomainFactory.addUpdateHandlers(trackedRace, courseDesignHandler, startTimeHandler, raceAbortedHandler, finishTimeUpdateHandler);
    }
}

