/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.server.gateway.serialization.impl.RegattaConfigurationJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Collection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DeviceConfigurationJsonSerializer
implements JsonSerializer<DeviceConfiguration> {
    public static final String FIELD_ID_AS_STRING = "idAsString";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_COURSE_AREA_NAMES = "courseAreaNames";
    public static final String FIELD_RESULTS_RECIPIENT = "resultsRecipient";
    public static final String FIELD_BY_VALUE_COURSE_DESIGNER_COURSE_NAMES = "byValueCourseNames";
    public static final String FIELD_REGATTA_CONFIGURATION = "procedures";
    public static final String FIELD_EVENT_ID = "eventId";
    public static final String FIELD_COURSE_AREA_ID = "courseAreaId";
    public static final String FIELD_PRIORITY = "priority";
    private final JsonSerializer<RegattaConfiguration> regattaConfigurationSerializer;

    public static DeviceConfigurationJsonSerializer create() {
        return new DeviceConfigurationJsonSerializer(RegattaConfigurationJsonSerializer.create());
    }

    public DeviceConfigurationJsonSerializer(JsonSerializer<RegattaConfiguration> serializer) {
        this.regattaConfigurationSerializer = serializer;
    }

    public JSONObject serialize(DeviceConfiguration object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_ID_AS_STRING, (Object)object.getId().toString());
        result.put((Object)FIELD_NAME, (Object)object.getName());
        if (object.getRegattaConfiguration() != null) {
            result.put((Object)FIELD_REGATTA_CONFIGURATION, (Object)this.regattaConfigurationSerializer.serialize((Object)object.getRegattaConfiguration()));
        }
        if (object.getAllowedCourseAreaNames() != null) {
            JSONArray courseAreaNames = new JSONArray();
            courseAreaNames.addAll((Collection)object.getAllowedCourseAreaNames());
            result.put((Object)FIELD_COURSE_AREA_NAMES, (Object)courseAreaNames);
        }
        if (object.getResultsMailRecipient() != null) {
            result.put((Object)FIELD_RESULTS_RECIPIENT, (Object)object.getResultsMailRecipient());
        }
        if (object.getByNameCourseDesignerCourseNames() != null) {
            JSONArray nameArray = new JSONArray();
            nameArray.addAll((Collection)object.getByNameCourseDesignerCourseNames());
            result.put((Object)FIELD_BY_VALUE_COURSE_DESIGNER_COURSE_NAMES, (Object)nameArray);
        }
        object.getEventId().ifPresent(eventId -> {
            Object object = result.put((Object)FIELD_EVENT_ID, (Object)eventId.toString());
        });
        object.getCourseAreaId().ifPresent(courseAreaId -> {
            Object object = result.put((Object)FIELD_COURSE_AREA_ID, (Object)courseAreaId.toString());
        });
        object.getPriority().ifPresent(priority -> {
            Object object = result.put((Object)FIELD_PRIORITY, priority);
        });
        return result;
    }
}

